% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blas_extras.R
\name{dsub}
\alias{dsub}
\title{In-place vector subtraction}
\usage{
dsub(N = NULL, X, INCX = 1L, Y, INCY = 1L)
}
\arguments{
\item{N}{Optional integer giving the number of elements. Defaults to `length(X)`.}

\item{X}{Double-precision vector, matrix or [`bigmemory::big.matrix`] input.}

\item{INCX}{Integer stride for traversing `X`.}

\item{Y}{Double-precision object updated in place.}

\item{INCY}{Integer stride for traversing `Y`.}
}
\value{
Invisibly returns the modified `Y`.
}
\description{
Updates `Y` by subtracting `X`, i.e. \eqn{Y := Y - X}.
}
\examples{
x <- 1:4
y <- rep(10, 4)
dsub(X = x, Y = y)
y

}
