% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_opt.R
\name{find_opt}
\alias{find_opt}
\title{Find optimal number of fourier variables}
\usage{
find_opt(
  x,
  dates,
  H = NULL,
  AO = NULL,
  method = "additive",
  l.max = 12,
  k.max = 42,
  by = 6
)
}
\arguments{
\item{x}{Numeric vector containing the observed weekly time series.}

\item{dates}{A vector of class \code{"Date"} corresponding to the observation dates.}

\item{H}{Optional matrix of holiday and trading-day regressors with
\code{nrow(H) = length(x)}.}

\item{AO}{Optional matrix of additive-outlier regressors with
\code{nrow(AO) = length(x)}.}

\item{method}{Character string specifying the decomposition type. Either
\code{"additive"} or \code{"multiplicative"}. If \code{"multiplicative"},
the series is log-transformed prior to detrending. Defaults to \code{"additive"}.}

\item{l.max}{Integer. Maximum number of monthly-cycle Fourier harmonics to consider.
Defaults to \code{12}.}

\item{k.max}{Integer. Maximum number of yearly-cycle Fourier harmonics to consider.
Defaults to \code{42}.}

\item{by}{Integer. Step size for the grid search over \code{k} and \code{l}.
Defaults to \code{6}.}
}
\value{
List with the optimal number of (yearly and monthly) fourier variables according to AIC, AICc and BIC.
}
\description{
Performs a grid search over combinations of yearly and monthly Fourier
(trigonometric) regressors and selects the number of terms that minimizes
AIC, AICc, or BIC. Candidate models are fitted by OLS to a detrended series,
where the trend is estimated using \code{\link[stats]{supsmu}}. Optional
holiday/trading-day regressors (\code{H}) and additive-outlier regressors
(\code{AO}) are included in every candidate specification if provided.
}
\examples{

data(gasoline.data)

res=find_opt(x=gasoline.data$y,dates=gasoline.data$date)
print(res)

}
