% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-show.R
\name{br_show_table}
\alias{br_show_table}
\title{Show model tidy results in table format}
\usage{
br_show_table(
  breg,
  ...,
  args_table_format = list(),
  export = FALSE,
  args_table_export = list()
)
}
\arguments{
\item{breg}{A regression object with results (must pass \code{assert_breg_obj_with_results()}).}

\item{...}{Arguments passing to \code{\link[=br_get_results]{br_get_results()}} for subsetting table.}

\item{args_table_format}{A list of arguments passing to \code{\link[insight:format_table]{insight::format_table()}}.}

\item{export}{Logical. If \code{TRUE}, show table for export purpose, e.g., present the table in Markdown or HTML format.}

\item{args_table_export}{A list of arguments passing to \code{\link[insight:export_table]{insight::export_table()}}. Only works when \code{export} is \code{TRUE}.}
}
\value{
A table
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
m <- br_pipeline(mtcars,
  y = "mpg",
  x = colnames(mtcars)[2:4],
  x2 = "vs",
  method = "gaussian"
)

br_show_table(m)
br_show_table(m, export = TRUE)
if (interactive()) {
  br_show_table(m, export = TRUE, args_table_export = list(format = "html"))
}
}
\seealso{
Other br_show: 
\code{\link{br_show_coxph_diagnostics}()},
\code{\link{br_show_fitted_line}()},
\code{\link{br_show_fitted_line_2d}()},
\code{\link{br_show_forest}()},
\code{\link{br_show_forest_circle}()},
\code{\link{br_show_forest_ggstats}()},
\code{\link{br_show_forest_ggstatsplot}()},
\code{\link{br_show_nomogram}()},
\code{\link{br_show_residuals}()},
\code{\link{br_show_risk_network}()},
\code{\link{br_show_survival_curves}()},
\code{\link{br_show_table_gt}()}
}
\concept{br_show}
