% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-show.R
\name{br_show_forest_circle}
\alias{br_show_forest_circle}
\title{Show a circular forest plot for regression results}
\usage{
br_show_forest_circle(
  breg,
  rm_controls = FALSE,
  style = c("points", "bars"),
  ref_line = TRUE,
  sort_by = c("none", "estimate", "estimate_desc", "pvalue", "variable"),
  subset = NULL,
  log_first = FALSE
)
}
\arguments{
\item{breg}{A regression object with results.}

\item{rm_controls}{If \code{TRUE}, remove control terms.}

\item{style}{Character string specifying the style of circular forest plot.
Options are:
\itemize{
\item \code{"points"} (default): Display point estimates with error bars in circular format
\item \code{"bars"}: Display as bars with points overlaid
}}

\item{ref_line}{Logical or numeric. If \code{TRUE}, shows reference circle at default value
(1 for exponentiated estimates, 0 for regular estimates).
If numeric, shows reference circle at specified value.
If \code{FALSE}, no reference circle is shown.}

\item{sort_by}{Character string specifying how to sort the variables.
Options are:
\itemize{
\item \code{"none"} (default): No sorting, use original order
\item \code{"estimate"}: Sort by effect estimate (ascending)
\item \code{"estimate_desc"}: Sort by effect estimate (descending)
\item \code{"pvalue"}: Sort by p-value (ascending, most significant first)
\item \code{"variable"}: Sort alphabetically by variable name
}}

\item{subset}{Expression for subsetting the results data (\code{br_get_results(breg)}).}

\item{log_first}{Log transformed the estimates and their confident intervals.}
}
\value{
A ggplot object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function creates a circular (polar) forest plot from regression results,
providing an alternative visualization to the traditional linear forest plot.
The function uses the same input as \code{\link[=br_show_forest]{br_show_forest()}} but displays the results
in a circular format using \code{\link[ggplot2:coord_radial]{ggplot2::coord_polar()}}.
}
\examples{
m <- br_pipeline(mtcars,
  y = "mpg",
  x = colnames(mtcars)[2:4],
  x2 = "vs",
  method = "gaussian"
)
br_show_forest_circle(m)
br_show_forest_circle(m, style = "bars")
br_show_forest_circle(m, sort_by = "estimate")
br_show_forest_circle(m, ref_line = FALSE)
br_show_forest_circle(m, ref_line = 0.5)
}
\references{
Implementation of circular forest plot \verb{https://mp.weixin.qq.com/s/PBKcsEFGrDSQJp6ZmUgfHA}
}
\seealso{
Other br_show: 
\code{\link{br_show_coxph_diagnostics}()},
\code{\link{br_show_fitted_line}()},
\code{\link{br_show_fitted_line_2d}()},
\code{\link{br_show_forest}()},
\code{\link{br_show_forest_ggstats}()},
\code{\link{br_show_forest_ggstatsplot}()},
\code{\link{br_show_nomogram}()},
\code{\link{br_show_residuals}()},
\code{\link{br_show_risk_network}()},
\code{\link{br_show_survival_curves}()},
\code{\link{br_show_table}()},
\code{\link{br_show_table_gt}()}
}
\concept{br_show}
