% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cdi_rate.R
\name{plot_cdi_rate}
\alias{plot_cdi_rate}
\title{Plot Brazilian CDI rate}
\usage{
plot_cdi_rate(data, language = "eng")
}
\arguments{
\item{data}{Tibble returned by \code{get_cdi_rate()}, with columns \code{date} and \code{value}.}

\item{language}{Language for titles and labels: "pt" (Portuguese) or "eng" (English).}
}
\value{
A \code{ggplot2} object showing the CDI rate over time.
}
\description{
Generates a time series plot of the CDI (Certificado de Depósito Interbancário) rate.
The CDI is the benchmark interest rate for interbank deposits in Brazil and serves
as a reference for many fixed income investments.
}
\examples{
\dontrun{
# Example 1: English version
cdi_data <- get_cdi_rate(2020, 2024)
cdi_plot <- plot_cdi_rate(cdi_data)
print(cdi_plot)

# Example 2: Portuguese version
dados_cdi <- get_cdi_rate(2020, 2024, language = "pt")
grafico_cdi <- plot_cdi_rate(dados_cdi, language = "pt")
print(grafico_cdi)
}
}
