% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/builders.R
\name{builders}
\alias{builders}
\alias{.namesL}
\alias{.buildL}
\alias{.namesSD}
\alias{.buildSD}
\alias{.namesZ}
\alias{.buildZ}
\title{Build the Variable Names or Data Objects for Estimation}
\usage{
.namesL(block, number)

.buildL(data, block, number, dpar)

.namesSD(ranef, block, dpar)

.buildSD(data, ranef, block, dpar)

.namesZ(block, number, dpar)

.buildZ(data, block, number, dpar)
}
\arguments{
\item{block}{Which random effect block to use. An integer.}

\item{number}{The number of elements in that random effect block. An integer.}

\item{data}{A data object. For example the result of \code{\link[brms:standata]{brms::make_standata()}}
for \code{\link[=.buildZ]{.buildZ()}}, which is a list,
or a dataset of the posterior draws such as from \code{\link[brms:draws-brms]{brms::as_draws_df()}}
for \code{\link[=.buildL]{.buildL()}} and \code{\link[=.buildSD]{.buildSD()}}.}

\item{dpar}{Which dpar to use. Does not apply to the L matrix.}

\item{ranef}{A data set with information about the model object random effects.
Only used for \code{\link[=.namesSD]{.namesSD()}} and \code{\link[=.buildSD]{.buildSD()}}.}
}
\value{
A character vector for all \code{.names} functions or a matrix
for all \code{.build} functions.
}
\description{
These are a set of internal utility functions.
They are not intended for general use.
}
\details{
\itemize{
\item \code{.namesL}: Generate names of an L matrix from \pkg{brms}.
Create the variable names for the Cholesky decomposition of the random effects
correlation matrix in \code{\link[brms:brm]{brms::brm()}}. Note that \code{\link[brms:brm]{brms::brm()}} returns the lower
triangular matrix and we want the upper triangular matrix, so the names are
transposed. The results can then be passed to \code{\link[=tab2mat]{tab2mat()}}
to convert the row vector into a matrix.
\item \code{.buildL}: Returns the L matrix object. Rows are posterior draws.
\item \code{.namesSD}: Create the names of random effect standard deviation estimates.
\item \code{.buildSD}: Return matrix of random effect standard deviation estimates. Rows are posterior draws.
\item \code{.namesZ}: Create the names of random effects data for predictions.
\item \code{.buildZ}: Return matrix of data for random effect predictions.
}
}
\keyword{internal}
