% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcapply.R
\name{bcapply}
\alias{bcapply}
\alias{bcapply,ANY-method}
\title{Apply Function to Pair of Arrays with Broadcasting}
\usage{
bcapply(x, y, f, ...)

\S4method{bcapply}{ANY}(x, y, f, v = NULL)
}
\arguments{
\item{x, y}{conformable atomic or recursive vectors/arrays.}

\item{f}{a function that takes in exactly \bold{2} arguments,
and \bold{returns} a result
that can be stored in a single element of a recursive or atomic array.}

\item{...}{further arguments passed to or from methods. \cr \cr}

\item{v}{either \code{NULL}, or single string, giving the scalar type for a single iteration. \cr
If \code{NULL} (default) or \code{"list"}, the result will be a recursive array. \cr
If it is certain that, for every iteration,
\code{f()} always results in a \bold{single atomic scalar} of \bold{exactly} a specific type,
the user can specify the type in \code{v} to pre-allocate the result. \cr
Pre-allocating the results leads to slightly faster and more memory efficient code. \cr
NOTE: Incorrectly specifying \code{v} leads to undefined behaviour; \cr
when unsure, leave \code{v} at its default value. \cr}
}
\value{
An atomic or recursive array with dimensions \code{bc_dim(x, y)}. \cr
Preserves some of the attributes of \code{x} and \code{y} similar to broadcasted infix operators,
as explained in \link{broadcast_operators}. \cr \cr
}
\description{
The \code{bcapply()} method
applies a function to 2 arrays element-wise with broadcasting. \cr
}
\examples{


# check for each element in one recursive array if values are present in another:
mylist <- list(
  as.raw(0:255),
  sample(c(TRUE, FALSE, NA), 100, TRUE),
  0:255,
  rnorm(10),
  rnorm(10) + rnorm(10) * -1i,
  sample(month.abb)
)
mylist <- c(mylist, list(mylist))
x <- array(sample(mylist, 50, TRUE), c(5, 5, 2))
y <- array(sample(mylist, 50, TRUE), c(5, 5, 2))

bcapply(x, y, `\%in\%`) # returns a dimensional list / recursive array

bcapply(x, y, \(x, y) any(x \%in\% y), v = "logical") # returns logical array

bcapply(x, y, \(x, y) all(x \%in\% y), v = "logical") # returns logical array



# calculate quartiles for each list item, and return numeric array of quartiles:
x <- list(
  a = 1:10,
  beta = exp(-3:3),
  logic = c(TRUE,FALSE,FALSE,TRUE)
)
print(x)
quantiles <- array(c(1:3/4), c(1, 3))
colnames(quantiles) <- paste0("q = ", quantiles)
print(quantiles)

out <- bcapply(x, quantiles, \(x, y) quantile(x, probs = y), v = "double")
print(out)
typeof(out)
}
