% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-ide.R
\name{btw_tool_ide_read_current_editor}
\alias{btw_tool_ide_read_current_editor}
\title{Tool: Read current file}
\usage{
btw_tool_ide_read_current_editor(
  selection = TRUE,
  consent = FALSE,
  `_intent` = ""
)
}
\arguments{
\item{selection}{Should only the selected text be included? If no text is
selected, the full file contents are returned.}

\item{consent}{Boolean indicating whether the user has consented to reading
the current file. The tool definition includes language to induce LLMs to
confirm with the user before calling the tool. Not all models will follow
these instructions. Users can also include the string \verb{@current_file} to
induce the tool.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
Returns the contents of the current editor.
}
\description{
Reads the current file using the \pkg{rstudioapi}, which works in RStudio,
Positron and VS Code (with the vscode-r extension).
}
\examples{
\dontshow{if (rstudioapi::hasFun("getSourceEditorContext")) withAutoprint(\{ # examplesIf}
btw_tool_ide_read_current_editor(consent = TRUE)
\dontshow{\}) # examplesIf}
}
\concept{ide tools}
