% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_bewerberboerse.R
\name{bewerberboerse_details}
\alias{bewerberboerse_details}
\title{Retrieve Bewerberboerse candidate details}
\usage{
bewerberboerse_details(referenznummer, flatten = FALSE, flatten_mode = "json")
}
\arguments{
\item{referenznummer}{Bewerber referenznummer.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble containing detailed information for a single candidate,
including personal details, skills, work history, education, and contact
preferences. Structure is similar to \code{\link[=bewerberboerse_search]{bewerberboerse_search()}} results.
}
\description{
Retrieve Bewerberboerse candidate details
}
\details{
Fetches details for a single candidate. The \code{referenznummer} typically comes
from \code{\link[=bewerberboerse_search]{bewerberboerse_search()}}. See https://bundesapi.github.io/bewerberboerse-api/.
}
\examples{
\dontrun{
Sys.setenv(BEWERBERBOERSE_API_KEY = "jobboerse-bewerbersuche-ui")
bunddev_auth_set("bewerberboerse", type = "api_key", env_var = "BEWERBERBOERSE_API_KEY")
bewerberboerse_details("12345", flatten = TRUE)
}
}
\seealso{
\code{\link[=bewerberboerse_search]{bewerberboerse_search()}} to find candidates and \code{\link[=bunddev_auth_set]{bunddev_auth_set()}} for auth.
}
