% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gam.R
\name{axe-gam}
\alias{axe-gam}
\alias{axe_call.gam}
\alias{axe_ctrl.gam}
\alias{axe_data.gam}
\alias{axe_env.gam}
\alias{axe_fitted.gam}
\title{Axing a gam.}
\usage{
\method{axe_call}{gam}(x, verbose = FALSE, ...)

\method{axe_ctrl}{gam}(x, verbose = FALSE, ...)

\method{axe_data}{gam}(x, verbose = FALSE, ...)

\method{axe_env}{gam}(x, verbose = FALSE, ...)

\method{axe_fitted}{gam}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed gam object.
}
\description{
gam objects are created from the \pkg{mgcv} package.
}
\examples{
\dontshow{if (rlang::is_installed("mgcv")) withAutoprint(\{ # examplesIf}

cars_gam <- mgcv::gam(mpg ~ s(disp, k = 3) + s(wt), data = mtcars)
cleaned_gam <- butcher(cars_gam, verbose = TRUE)
\dontshow{\}) # examplesIf}
}
