% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-forecast.R, R/print-forecast.R,
%   R/member.R
\name{forecast_roll}
\alias{forecast_roll}
\alias{print.bvharcv}
\alias{is.bvharcv}
\alias{knit_print.bvharcv}
\alias{forecast_roll.olsmod}
\alias{forecast_roll.normaliw}
\alias{forecast_roll.ldltmod}
\alias{forecast_roll.svmod}
\title{Out-of-sample Forecasting based on Rolling Window}
\usage{
forecast_roll(
  object,
  n_ahead,
  y_test,
  level = 0.05,
  newxreg = NULL,
  num_thread = 1,
  ...
)

\method{print}{bvharcv}(x, digits = max(3L, getOption("digits") - 3L), ...)

is.bvharcv(x)

\method{knit_print}{bvharcv}(x, ...)

\method{forecast_roll}{olsmod}(
  object,
  n_ahead,
  y_test,
  level = 0.05,
  newxreg = NULL,
  num_thread = 1,
  ...
)

\method{forecast_roll}{normaliw}(
  object,
  n_ahead,
  y_test,
  level = 0.05,
  newxreg = NULL,
  num_thread = 1,
  use_fit = TRUE,
  ...
)

\method{forecast_roll}{ldltmod}(
  object,
  n_ahead,
  y_test,
  level = 0.05,
  newxreg = NULL,
  num_thread = 1,
  stable = FALSE,
  sparse = FALSE,
  med = FALSE,
  lpl = FALSE,
  mcmc = TRUE,
  use_fit = TRUE,
  verbose = FALSE,
  ...
)

\method{forecast_roll}{svmod}(
  object,
  n_ahead,
  y_test,
  level = 0.05,
  newxreg = NULL,
  num_thread = 1,
  use_sv = TRUE,
  stable = FALSE,
  sparse = FALSE,
  med = FALSE,
  lpl = FALSE,
  mcmc = TRUE,
  use_fit = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{Model object}

\item{n_ahead}{Step to forecast in rolling window scheme}

\item{y_test}{Test data to be compared. Use \code{\link[=divide_ts]{divide_ts()}} if you don't have separate evaluation dataset.
Use numeric, the length of test period, if \code{object} is the full sample result.
Numeric \code{y_test} will automatically splits \code{object$y}.
In this case, \code{use_fit} is forced to become \code{FALSE}.}

\item{level}{Specify alpha of confidence interval level 100(1 - alpha) percentage. By default, .05.}

\item{newxreg}{New values for exogenous variables.
Should have the same row numbers as \code{y_test}.}

\item{num_thread}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Number of threads}

\item{...}{not used}

\item{x}{Any object}

\item{digits}{digit option to print}

\item{use_fit}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Use \code{object} result for the first window. By default, \code{TRUE}.}

\item{stable}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Filter only stable coefficient draws in MCMC records.}

\item{sparse}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Apply restriction. By default, \code{FALSE}.}

\item{med}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} If \code{TRUE}, use median of forecast draws instead of mean (default).}

\item{lpl}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Compute log-predictive likelihood (LPL). By default, \code{FALSE}.}

\item{mcmc}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} If \code{TRUE}, run new MCMC in new windows. By default, \code{TRUE}.}

\item{verbose}{Print the progress bar in the console. By default, \code{FALSE}.}

\item{use_sv}{Use SV term}
}
\value{
\code{predbvhar_roll} \link{class}
}
\description{
This function conducts rolling window forecasting.
}
\details{
Rolling windows forecasting fixes window size.
It moves the window ahead and forecast h-ahead in \code{y_test} set.
}
\references{
Hyndman, R. J., & Athanasopoulos, G. (2021). \emph{Forecasting: Principles and practice} (3rd ed.). OTEXTS.
}
