% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covar_sim.R
\name{covar_join}
\alias{covar_join}
\alias{join_covar}
\alias{\%join\%}
\title{Add additional covariates to existing covariate random generator}
\usage{
covar_join(f, ...)
}
\arguments{
\item{f}{covariate random generator}

\item{...}{additional covariate generators or constant covariates}
}
\value{
function, with returned data type matching that of \code{f}
}
\description{
For use with \link{Trial} objects, this function makes it possible to
easily add additional covariates to an existing random generator
(function(n ...) returning a data.frame or data.table)
}
\examples{
# single period
n <- 5
c1 <- function(n) data.frame(a = rnorm(n))
c2 <- function(n) data.frame(b = rnorm(n))
x <- c1 \%join\% c2
x(n)

# adding covariates that remain constant when sampling
x <- c1 \%join\% data.frame(b = rnorm(n))
all.equal(x(n)$b, x(n)$b)

# adding multiple anonymous functions require parenthesis enclosing, with
# the exception of the last function
x <- c1 \%join\%
 (\(n) data.frame(b = rnorm(n))) \%join\%
 \(n) data.frame(c = rnorm(n))
x(n)

# multiple periods
base <- setargs(covar_loggamma, normal.cor = .5)
x <- base \%join\%
  function(n) list(
      data.frame(a = rbinom(n, 1, 0.5)),
      data.frame(a = rbinom(n, 1, 0.5))
    )
x(n)

# constant covariate
x <- base \%join\% list(data.frame(a = 0), data.frame(a = 1))
x(n)

# baseline covariate
x <- base \%join\% function(n) data.frame(w = rnorm(n))
x(n)
}
