% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{is_acyclic}
\alias{is_acyclic}
\title{Is the \code{caugi} acyclic?}
\usage{
is_acyclic(cg, force_check = FALSE)
}
\arguments{
\item{cg}{A \code{caugi} object.}

\item{force_check}{Logical; if \code{TRUE}, the function will test if the graph is
acyclic, if \code{FALSE} (default), it will look at the graph class and match
it, if possible.}
}
\value{
A logical value indicating whether the graph is acyclic.
}
\description{
Checks if the given \code{caugi} graph is acyclic.
}
\details{
Logically, it should not be possible to have a graph class of "DAG" or "PDAG"
that has cycles, but in case the user modified the graph after creation in
some unforeseen way that could have introduced cycles, this function allows
to force a check of acyclicity, if needed.
}
\examples{
cg_acyclic <- caugi(
  A \%-->\% B,
  B \%-->\% C,
  class = "DAG"
)
is_acyclic(cg_acyclic) # TRUE
cg_cyclic <- caugi(
  A \%-->\% B,
  B \%-->\% C,
  C \%-->\% A,
  class = "UNKNOWN"
)
is_acyclic(cg_cyclic) # FALSE

}
\seealso{
Other queries: 
\code{\link{ancestors}()},
\code{\link{anteriors}()},
\code{\link{children}()},
\code{\link{descendants}()},
\code{\link{districts}()},
\code{\link{edge_types}()},
\code{\link{edges}()},
\code{\link{exogenous}()},
\code{\link{is_admg}()},
\code{\link{is_ag}()},
\code{\link{is_caugi}()},
\code{\link{is_cpdag}()},
\code{\link{is_dag}()},
\code{\link{is_empty_caugi}()},
\code{\link{is_mag}()},
\code{\link{is_pdag}()},
\code{\link{is_ug}()},
\code{\link{m_separated}()},
\code{\link{markov_blanket}()},
\code{\link{neighbors}()},
\code{\link{nodes}()},
\code{\link{parents}()},
\code{\link{same_nodes}()},
\code{\link{spouses}()},
\code{\link{subgraph}()},
\code{\link{topological_sort}()}
}
\concept{queries}
