% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{same_nodes}
\alias{same_nodes}
\title{Same nodes?}
\usage{
same_nodes(cg1, cg2, throw_error = FALSE)
}
\arguments{
\item{cg1}{A \code{caugi} object.}

\item{cg2}{A \code{caugi} object.}

\item{throw_error}{Logical; if \code{TRUE}, throws an error if the graphs do not
have the same nodes.}
}
\value{
A logical indicating if the two graphs have the same nodes.
}
\description{
Check if two \code{caugi} objects have the same nodes.
}
\examples{
cg1 <- caugi(
  A \%-->\% B,
  class = "DAG"
)
cg2 <- caugi(
  A \%-->\% B + C,
  class = "DAG"
)
same_nodes(cg1, cg2) # FALSE

}
\seealso{
Other queries: 
\code{\link{ancestors}()},
\code{\link{anteriors}()},
\code{\link{children}()},
\code{\link{descendants}()},
\code{\link{districts}()},
\code{\link{edge_types}()},
\code{\link{edges}()},
\code{\link{exogenous}()},
\code{\link{is_acyclic}()},
\code{\link{is_admg}()},
\code{\link{is_ag}()},
\code{\link{is_caugi}()},
\code{\link{is_cpdag}()},
\code{\link{is_dag}()},
\code{\link{is_empty_caugi}()},
\code{\link{is_mag}()},
\code{\link{is_pdag}()},
\code{\link{is_ug}()},
\code{\link{m_separated}()},
\code{\link{markov_blanket}()},
\code{\link{neighbors}()},
\code{\link{nodes}()},
\code{\link{parents}()},
\code{\link{spouses}()},
\code{\link{subgraph}()},
\code{\link{topological_sort}()}
}
\concept{queries}
