% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cff_read.R
\name{cff_read}
\alias{cff_read}
\alias{cff_read_cff_citation}
\alias{cff_read_description}
\alias{cff_read_citation}
\alias{cff_read_bib}
\title{Read an external file as a \code{\link{cff}} object}
\usage{
cff_read(path, ...)

cff_read_cff_citation(path, ...)

cff_read_description(
  path,
  cff_version = "1.2.0",
  gh_keywords = TRUE,
  authors_roles = c("aut", "cre"),
  ...
)

cff_read_citation(path, meta = NULL, ...)

cff_read_bib(path, encoding = "UTF-8", ...)
}
\arguments{
\item{path}{Path to a file.}

\item{...}{Arguments to be passed to other functions (i.e. to
\code{\link[yaml:read_yaml]{yaml::read_yaml()}}, \code{\link[bibtex:read.bib]{bibtex::read.bib()}}, etc.).}

\item{cff_version}{The Citation File Format schema version that the
\code{CITATION.cff} file adheres to for providing the citation metadata.}

\item{gh_keywords}{Logical \code{TRUE/FALSE}. If the package is hosted on
GitHub, would you like to add the repo topics as keywords?}

\item{authors_roles}{Roles to be considered as authors of the package when
generating the \code{CITATION.cff} file. See \strong{Details}.}

\item{meta}{A list of package metadata as obtained by
\code{\link[utils:packageDescription]{utils::packageDescription()}} or \code{NULL} (the default). See \strong{Details}.}

\item{encoding}{Encoding to be assumed for \code{path}. See \code{\link[=readLines]{readLines()}}.}
}
\value{
\itemize{
\item \code{cff_read_cff_citation()} and \code{cff_read_description()} returns a object
with class \code{cff}.
\item \code{cff_read_citation()} and \code{cff_read_bib()} returns an object of classes
\code{\link[=cff_ref_lst]{cff_ref_lst, cff}} according to the \code{definitions.references}
specified in the \href{https://github.com/citation-file-format/citation-file-format/blob/main/schema-guide.md}{Citation File Format schema}.
}

Learn more about the \CRANpkg{cffr} class system in \link{cff_class}.
}
\description{
Read files and convert them to \code{\link{cff}} objects. Files supported
are:
\itemize{
\item \code{CITATION.cff} files.
\item \code{DESCRIPTION} files.
\item \strong{R} citation files (usually located in \code{inst/CITATION}).
\item BibTeX files (with extension \verb{*.bib}).
}

\code{\link[=cff_read]{cff_read()}} would try to guess the type of file provided in \code{path}. However
we provide a series of alias for each specific type of file:
\itemize{
\item \code{\link[=cff_read_cff_citation]{cff_read_cff_citation()}}, that uses \code{\link[yaml:read_yaml]{yaml::read_yaml()}}.
\item \code{\link[=cff_read_description]{cff_read_description()}}, using \code{\link[desc:desc]{desc::desc()}}.
\item \code{\link[=cff_read_citation]{cff_read_citation()}} uses \code{\link[utils:citation]{utils::readCitationFile()}}.
\item \code{\link[=cff_read_bib]{cff_read_bib()}}  requires \CRANpkg{bibtex} (>= 0.5.0) and uses
\code{\link[bibtex:read.bib]{bibtex::read.bib()}}.
}
}
\details{
For details of \code{cff_read_description()} see \code{\link[=cff_create]{cff_create()}}.
\subsection{The \code{meta} object}{

Section 1.9 CITATION files of \emph{Writing R Extensions} (R Core Team 2023)
specifies how to create dynamic \code{CITATION} files using \code{meta} object, hence
the \code{meta} argument in \code{\link[=cff_read_citation]{cff_read_citation()}} may be needed for reading
some files correctly.
}
}
\examples{

# Create cff object from cff file

from_cff_file <- cff_read(system.file("examples/CITATION_basic.cff",
  package = "cffr"
))

head(from_cff_file, 7)

# Create cff object from DESCRIPTION
from_desc <- cff_read(system.file("examples/DESCRIPTION_basic",
  package = "cffr"
))

from_desc

# Create cff object from BibTex

if (requireNamespace("bibtex", quietly = TRUE)) {
  from_bib <- cff_read(system.file("examples/example.bib",
    package = "cffr"
  ))

  # First item only
  from_bib[[1]]
}
# Create cff object from CITATION
from_citation <- cff_read(system.file("CITATION", package = "cffr"))

# First item only
from_citation[[1]]

}
\references{
\itemize{
\item R Core Team (2023). \emph{Writing R Extensions}.
\url{https://cran.r-project.org/doc/manuals/r-release/R-exts.html}
\item Hernangomez D (2022). "BibTeX and CFF, a potential crosswalk."
\emph{The cffr package, Vignettes}. \doi{10.21105/joss.03900},
\url{https://docs.ropensci.org/cffr/articles/bibtex-cff.html}.
}
}
\seealso{
The underlying functions used for reading external files:
\itemize{
\item \code{\link[yaml:read_yaml]{yaml::read_yaml()}} for \code{CITATION.cff} files.
\item \code{\link[desc:desc]{desc::desc()}} for \code{DESCRIPTION} files.
\item \code{\link[utils:citation]{utils::readCitationFile()}} for \strong{R} citation files.
\item \code{\link[bibtex:read.bib]{bibtex::read.bib()}} for BibTeX files (extension \verb{*.bib}).
}

Other functions for reading external files:
\code{\link{cff_read_bib_text}()}

Other functions for working with BibTeX format:
\code{\link{as_bibentry}()},
\code{\link{cff_read_bib_text}()},
\code{\link{cff_write_bib}()},
\code{\link{encoded_utf_to_latex}()}
}
\concept{bibtex}
\concept{reading}
