% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cits.R
\name{cits}
\alias{cits}
\title{Controlled Interrupted Time Series (CITS) Estimation}
\usage{
cits(
  data,
  y_col,
  T_col,
  I_col,
  E_col,
  TI_col = NULL,
  ET_col = NULL,
  EI_col = NULL,
  ETI_col = NULL,
  p_range = 0:3,
  q_range = 0:3
)
}
\arguments{
\item{data}{A data frame containing the variables for CITS analysis.}

\item{y_col}{Outcome variable column name (string).}

\item{T_col}{Time index column name (string).}

\item{I_col}{Intervention indicator column name (string).
Numeric: 1 indicates the intervention is applied at that time, 0 otherwise.}

\item{E_col}{Group indicator column name (string).
Numeric: 1 indicates the treatment/experimental group, 0 indicates the control group.}

\item{TI_col}{Optional: Column name for the T × I interaction (default = NULL). Will be computed if NULL.}

\item{ET_col}{Optional: Column name for the E × T interaction (default = NULL). Will be computed if NULL.}

\item{EI_col}{Optional: Column name for the E × I interaction (default = NULL). Will be computed if NULL.}

\item{ETI_col}{Optional: Column name for the E × T × I interaction (default = NULL). Will be computed if NULL.}

\item{p_range}{Range of autoregressive (AR) terms to search (default = 0:3).}

\item{q_range}{Range of moving average (MA) terms to search (default = 0:3).}
}
\value{
A list containing:
  \describe{
    \item{model}{The fitted GLS model object.}
    \item{robust_se}{CR2 robust covariance matrix from \code{clubSandwich}.}
    \item{data}{Data frame including fitted values and standard errors.}
    \item{best_p}{Selected AR order based on AIC.}
    \item{best_q}{Selected MA order based on AIC.}
    \item{arma_used}{Logical: TRUE if ARMA correlation selected, else FALSE.}
  }
}
\description{
Fit a generalized least squares (GLS) Controlled Interrupted Time Series (CITS) model
with optional autoregressive–moving-average (ARMA) correlation.
Robust standard errors (CR2) are computed using the \code{clubSandwich} package.
Interaction terms are automatically created if not provided.
}
\details{
This function fits a controlled interrupted time series (CITS) model using
generalized least squares (GLS). It automatically calculates interaction terms
if they are not provided in the input data. If ARMA fitting fails or produces
non-stationary estimates, the function falls back to GLS without correlation.

The treatment group (`E_col = 1`) is the group that receives the intervention,
while `E_col = 0` denotes the control group. The intervention indicator (`I_col`)
marks whether the intervention is applied at a given time point.
}
\examples{
df <- data.frame(
  T = 1:100,
  E = rep(c(0,1), each = 100),
  I = c(rep(0,50), rep(1,50), rep(0,50), rep(1,50)),
  y = rnorm(200)
)

# Use lightweight ARMA search for examples (CRAN speed requirement)
res <- cits(
  df,
  y_col = "y",
  T_col = "T",
  I_col = "I",
  E_col = "E",
  p_range = 0:1,
  q_range = 0:0
)

summary(res$model)

}
