\name{awol_delirium_risk}
\alias{awol_delirium_risk}
\title{
AWOL Score for Delirium
}
\description{
Calculates the AWOL score to predict the risk of developing delirium during hospitalization. The score assesses four risk factors: Age, ability to spell "World" backwards, Orientation, and iLlnes severity.
}
\usage{
awol_delirium_risk(age, spell_world_failed, orientation_failed,
                   illness_severity_moderate_severe)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (>= 80 years adds +1 point).
}
  \item{spell_world_failed}{
Numeric (0 or 1). Failure to spell "World" backwards correctly. (1 = Yes/Failed, +1 point).
}
  \item{orientation_failed}{
Numeric (0 or 1). Failure to correctly name the city, state, county, hospital name, or floor. (1 = Yes/Failed, +1 point).
}
  \item{illness_severity_moderate_severe}{
Numeric (0 or 1). Nurse-rated illness severity is "Moderate" or "Severe" (as opposed to Mild). (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{AWOL_Score}{The total calculated score (Range 0-4).}
\item{Risk_Category}{General classification (Low Risk < 2, High Risk >= 2).}
\item{Est_Delirium_Risk}{Estimated percentage probability of developing delirium.}
}
\references{
Douglas VC, Hessler CS, Dhaliwal G, et al. The AWOL tool: derivation and validation of a delirium prediction rule. J Hosp Med. 2013;8(9):493-499. doi:10.1002/jhm.2062
}
\examples{

# Example 1: High Risk
# 82yo (+1), Failed spelling (+1), Oriented (0), Moderate Severity (+1)
# Score = 3 (~37\% risk)
awol_delirium_risk(82, 1, 0, 1)

# Example 2: Low Risk
# 65yo (0), Spelled correctly (0), Oriented (0), Mild Severity (0)
# Score = 0 (~2\% risk)
awol_delirium_risk(65, 0, 0, 0)
}
