\name{has_bled_score}
\alias{has_bled_score}
\title{
HAS-BLED Score for Major Bleeding Risk
}
\description{
Calculates the HAS-BLED score to estimate the 1-year risk of major bleeding in patients with atrial fibrillation who are being considered for or are taking oral anticoagulation. It helps clinicians assess the risk-benefit ratio of anticoagulation therapy and identify modifiable risk factors.
}
\usage{
has_bled_score(hypertension, abnormal_renal_function, abnormal_liver_function,
               stroke_history, bleeding_history, labile_inr, elderly_gt_65,
               drug_usage, alcohol_usage)
}
\arguments{
  \item{hypertension}{
Numeric (0 or 1). Uncontrolled systolic blood pressure > 160 mmHg. (1 = Yes, +1 point).
}
  \item{abnormal_renal_function}{
Numeric (0 or 1). Chronic dialysis, renal transplantation, or serum creatinine >= 2.26 mg/dL. (1 = Yes, +1 point).
}
  \item{abnormal_liver_function}{
Numeric (0 or 1). Chronic hepatic disease (e.g., cirrhosis) or biochemical evidence of significant hepatic derangement. (1 = Yes, +1 point).
}
  \item{stroke_history}{
Numeric (0 or 1). History of previous ischemic stroke. (1 = Yes, +1 point).
}
  \item{bleeding_history}{
Numeric (0 or 1). Prior major bleeding or predisposition to bleeding (e.g., anemia). (1 = Yes, +1 point).
}
  \item{labile_inr}{
Numeric (0 or 1). Unstable/high INRs or time in therapeutic range < 60\%. (1 = Yes, +1 point).
}
  \item{elderly_gt_65}{
Numeric (0 or 1). Age > 65 years. (1 = Yes, +1 point).
}
  \item{drug_usage}{
Numeric (0 or 1). Concomitant use of antiplatelets (e.g., aspirin, clopidogrel) or NSAIDs. (1 = Yes, +1 point).
}
  \item{alcohol_usage}{
Numeric (0 or 1). Alcohol abuse or intake > 8 drinks/week. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{HAS_BLED_Score}{The calculated score (Range 0-9).}
\item{Annual_Bleeding_Risk}{Estimated annual risk of major bleeding events.}
\item{Recommendation}{Clinical guidance based on the risk level.}
}
\references{
Pisters R, Lane DA, Nieuwlaat R, de Vos CB, Crijns HJ, Lip GY. A novel user-friendly score (HAS-BLED) to assess 1-year risk of major bleeding in patients with atrial fibrillation: the Euro Heart Survey. Chest. 2010;138(5):1093-1100. doi:10.1378/chest.10-0134
}
\examples{

# Example 1: High Risk
# HTN (1), Renal (1), Stroke (1), Elderly (1), Drugs (1)
# Score = 5
has_bled_score(1, 1, 0, 1, 0, 0, 1, 1, 0)

# Example 2: Low Risk
# Only Elderly (1)
# Score = 1
has_bled_score(0, 0, 0, 0, 0, 0, 1, 0, 0)
}
