\name{modified_minnesota_detox_scale}
\alias{modified_minnesota_detox_scale}
\title{
Modified Minnesota Detoxification Scale (MMDS)
}
\description{
Calculates the Modified Minnesota Detoxification Scale (MMDS) score, used to assess the severity of alcohol withdrawal and guide treatment. The scale evaluates vital signs (pulse, diastolic BP) and clinical signs (tremor, sweat, hallucinations, agitation, orientation, seizures).
}
\usage{
modified_minnesota_detox_scale(pulse_rate, diastolic_bp, tremor, sweat,
                               hallucinations, agitation, orientation, seizures)
}
\arguments{
  \item{pulse_rate}{
Numeric. Patient's pulse rate in beats per minute.
}
  \item{diastolic_bp}{
Numeric. Patient's diastolic blood pressure in mmHg.
}
  \item{tremor}{
Numeric (0-3). Severity of tremor. (0: None, 1: Visible, 2: Marked, 3: Severe/Gross).
}
  \item{sweat}{
Numeric (0-3). Severity of sweating. (0: None, 1: Moist, 2: Bead/wet, 3: Drenching).
}
  \item{hallucinations}{
Numeric (0-3). Presence/severity of hallucinations. (0: None, 1: Mild/transient, 2: Moderate/distressing, 3: Severe/continuous).
}
  \item{agitation}{
Numeric (0-3). Severity of agitation. (0: None, 1: Restless, 2: Agitated, 3: Combative).
}
  \item{orientation}{
Numeric (0-4). Orientation score (based on time, place, person). Typically scored inversely (0: Oriented x3, 4: Disoriented). *Note: Specific MDCalc implementation details may vary, usually ranges 0-4 or similar.*
}
  \item{seizures}{
Numeric (0-2). Seizure activity. (0: None, 1: One, 2: Multiple).
}
}
\value{
A list containing:
\item{MMDS_Score}{The calculated total score (Range 0-24+).}
\item{Severity_Interpretation}{Assessment of withdrawal severity (e.g., >=10 suggests severe).}
}
\references{
DeMarce JM, Burden JL, Lash SJ, et al. Outcome of a modified Minnesota detoxification scale for alcohol withdrawal. Addict Behav. 2014;39(11):1670-1673. doi:10.1016/j.addbeh.2014.06.003
}
\examples{

# Example 1: Severe Withdrawal
# Pulse 130 (3), DBP 115 (3), Severe Tremor (3), Drenching Sweat (3), Hallucinations (3)
# Score = 15+
modified_minnesota_detox_scale(130, 115, 3, 3, 3, 0, 0, 0)

# Example 2: Mild Withdrawal
# Pulse 90 (1), DBP 85 (0), Mild tremor (1), No other signs
# Score = 2
modified_minnesota_detox_scale(90, 85, 1, 0, 0, 0, 0, 0)
}
