\name{reveal_pah_risk_score}
\alias{reveal_pah_risk_score}
\title{
REVEAL Registry Risk Score 2.0 for Pulmonary Arterial Hypertension (PAH)
}
\description{
Calculates the REVEAL 2.0 Risk Score to predict 12-month survival in patients with Pulmonary Arterial Hypertension (PAH). This updated version refines the original REVEAL score by incorporating renal function, all-cause hospitalizations, and modifying cut-points for other variables.
}
\usage{
reveal_pah_risk_score(who_group1_subgroup, age_years, male_sex,
                      renal_insufficiency, nyha_class, systolic_bp, heart_rate,
                      hospitalizations_6mo, six_min_walk_distance,
                      bnp_level = NULL, nt_probnp_level = NULL,
                      pericardial_effusion, dlco_predicted, mrap_gt_20, pvr_lt_5)
}
\arguments{
  \item{who_group1_subgroup}{
String. Subgroup of PAH.
"portopulmonary": +3 pts.
"familial" or "heritable": +2 pts.
"ctd" (Connective Tissue Disease): +1 pt.
"other" (Idiopathic, Drug/Toxin, CHD, HIV, etc.): 0 pts.
}
  \item{age_years}{
Numeric. Patient age in years.
}
  \item{male_sex}{
Numeric (0 or 1). Is the patient male? (1 = Yes). (Male > 60 years adds +2 pts).
}
  \item{renal_insufficiency}{
Numeric (0 or 1). eGFR < 60 mL/min/1.73m^2 or clinical renal insufficiency. (1 = Yes, +1 pt).
}
  \item{nyha_class}{
Numeric (1-4). NYHA Functional Class.
Class I: -1 pt.
Class II: 0 pts.
Class III: +1 pt.
Class IV: +2 pts.
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg. (< 110 mmHg adds +1 pt).
}
  \item{heart_rate}{
Numeric. Heart rate in bpm. (> 96 bpm adds +1 pt).
}
  \item{hospitalizations_6mo}{
Numeric (0 or 1). Any all-cause hospitalizations within the last 6 months? (1 = Yes, +1 pt).
}
  \item{six_min_walk_distance}{
Numeric. 6-Minute Walk Distance in meters.
>= 440m: -2 pts.
320-<440m: -1 pt.
165-<320m: 0 pts.
< 165m: +1 pt.
}
  \item{bnp_level}{
Numeric (Optional). BNP level in pg/mL.
<50: -2 pts.
50-<200: 0 pts.
200-<800: +1 pt.
>=800: +2 pts.
}
  \item{nt_probnp_level}{
Numeric (Optional). NT-proBNP level in pg/mL. (If provided, takes precedence or used if BNP missing).
<300: -2 pts.
300-<1100: 0 pts.
>=1100: +2 pts.
}
  \item{pericardial_effusion}{
Numeric (0 or 1). Presence of pericardial effusion on echocardiogram. (1 = Yes, +1 pt).
}
  \item{dlco_predicted}{
Numeric. DLCO percent predicted. (< 40\% adds +1 pt).
}
  \item{mrap_gt_20}{
Numeric (0 or 1). Mean Right Atrial Pressure > 20 mmHg on RHC within 1 year. (1 = Yes, +1 pt).
}
  \item{pvr_lt_5}{
Numeric (0 or 1). Pulmonary Vascular Resistance < 5 Wood units on RHC. (1 = Yes, -1 pt).
}
}
\value{
A list containing:
\item{REVEAL_2_0_Score}{The calculated risk score (Range approx -6 to +23).}
\item{Risk_Group}{Classification (Low <=6, Intermediate 7-8, High >=9).}
\item{Mortality_Risk_12_Month}{Estimated 12-month mortality risk.}
}
\references{
Benza RL, Gomberg-Maitland M, Elliott CG, et al. Predicting Survival in Patients With Pulmonary Arterial Hypertension: The REVEAL Risk Score Calculator 2.0 and Comparison With ESC/ERS-Based Risk Assessment Strategies. Chest. 2019;156(2):323-337. doi:10.1016/j.chest.2019.02.004
}
\examples{

# Example 1: Low Risk
# Idiopathic, 40yo Female, Normal Renal, NYHA II, SBP 120, HR 80,
#No Hosp, 6MWD 450, NT-proBNP 200, No Effusion, DLCO 60, mRAP 10, PVR 4
# Score = 0 + 0 + 0 + 0 + 0 + 0 + 0 - 2 - 2 + 0 + 0 + 0 - 1 = -5
reveal_pah_risk_score("other", 40, 0, 0, 2, 120, 80, 0, 450, NULL, 200, 0, 60, 0, 1)

# Example 2: High Risk
# CTD (+1), 70yo Male (+2), Renal (+1), NYHA III (+1), SBP 100 (+1),
#HR 100 (+1), Hosp (+1), 6MWD 150 (+1), BNP 900 (+2), Effusion (+1),
#DLCO 30 (+1), mRAP 22 (+1), PVR 8 (0)
# Score = 1 + 2 + 1 + 1 + 1 + 1 + 1 + 1 + 2 + 1 + 1 + 1 + 0 = 14
reveal_pah_risk_score("ctd", 70, 1, 1, 3, 100, 100, 1, 150, 900, NULL, 1, 30, 1, 0)
}
