\name{sodium_deficit_hyponatremia}
\alias{sodium_deficit_hyponatremia}
\title{
Sodium Deficit Calculator for Hyponatremia
}
\description{
Calculates the total sodium deficit in milliequivalents (mEq) required to raise the serum sodium concentration to a specified target level. The calculation estimates Total Body Water (TBW) based on the patient's sex, age category (adult, elderly, child), and weight.
}
\usage{
sodium_deficit_hyponatremia(current_sodium, target_sodium, weight_kg, sex,
                            patient_type = "adult")
}
\arguments{
  \item{current_sodium}{
Numeric. Current serum sodium level (mEq/L).
}
  \item{target_sodium}{
Numeric. Desired target serum sodium level (mEq/L). Note: Correction should generally not exceed 8-12 mEq/L in 24 hours to avoid osmotic demyelination syndrome.
}
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{patient_type}{
String. Patient age category to determine TBW fraction.
"adult": Male 0.6, Female 0.5.
"elderly": Male 0.5, Female 0.45.
"child": 0.6 (Both sexes).
}
}
\details{
The formula used is:
\deqn{Sodium Deficit (mEq) = TBW \times (Target Na - Current Na)}
Where TBW is estimated as a fraction of body weight based on the selected category.
}
\value{
A list containing:
\item{Sodium_Deficit_mEq}{The estimated amount of sodium required to reach the target level.}
\item{Total_Body_Water_L}{The estimated Total Body Water.}
}
\references{
Adrogué HJ, Madias NE. Hyponatremia. N Engl J Med. 2000;342(21):1581-1589. doi:10.1056/NEJM200005253422107
}
\examples{

# Example 1: Adult Male, Na 120 to 125
# TBW = 0.6 * 70 = 42 L
# Deficit = 42 * (125 - 120) = 210 mEq
sodium_deficit_hyponatremia(120, 125, 70, "male", "adult")

# Example 2: Elderly Female, Na 115 to 120
# TBW = 0.45 * 60 = 27 L
# Deficit = 27 * (120 - 115) = 135 mEq
sodium_deficit_hyponatremia(115, 120, 60, "female", "elderly")
}
