% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo_waic.R
\name{loo.clmstan}
\alias{loo.clmstan}
\title{Leave-One-Out Cross-Validation for clmstan objects}
\usage{
\method{loo}{clmstan}(x, ..., r_eff = NULL, cores = getOption("mc.cores", 1), save_psis = FALSE)
}
\arguments{
\item{x}{A \code{clmstan} object returned by \code{\link{clm_stan}}.}

\item{...}{Additional arguments passed to \code{\link[loo]{loo}}.}

\item{r_eff}{A vector of relative effective sample sizes for each observation,
or \code{NULL} (default) to compute them automatically using
\code{\link[loo]{relative_eff}}. Set to \code{NA} to skip r_eff computation
(faster but diagnostics may be over-optimistic).}

\item{cores}{The number of cores to use for parallel computation.
Defaults to \code{getOption("mc.cores", 1)}.}

\item{save_psis}{If \code{TRUE}, the PSIS object is saved in the returned
object. This is required for some downstream functions like \code{E_loo()}.
Default is \code{FALSE}.}
}
\value{
An object of class \code{c("psis_loo", "loo")} containing:
\itemize{
\item \code{estimates}: A matrix with columns \code{Estimate} and \code{SE}
for \code{elpd_loo}, \code{p_loo}, and \code{looic}.
\item \code{pointwise}: A matrix with pointwise contributions.
\item \code{diagnostics}: A list with Pareto k values and effective
sample sizes for each observation.
}
}
\description{
Computes approximate leave-one-out cross-validation (LOO-CV) for a
fitted cumulative link model using Pareto smoothed importance sampling (PSIS).
}
\details{
The function extracts the log-likelihood matrix (\code{log_lik}) computed in
the generated quantities block of the Stan model and passes it to
\code{\link[loo]{loo}}.

\strong{Pareto k diagnostics:} Observations with high Pareto k values
(k > 0.7) indicate potential problems with the LOO approximation for those
observations. Use \code{plot()} on the returned object to visualize the
Pareto k values.

\strong{Model comparison:} Use \code{\link[loo]{loo_compare}} to compare
multiple models. Models with higher \code{elpd_loo} are preferred.
}
\examples{
\dontrun{
fit <- clm_stan(rating ~ temp, data = wine)
loo_result <- loo(fit)
print(loo_result)
plot(loo_result)

# Compare two models
fit1 <- clm_stan(rating ~ temp, data = wine, link = "logit")
fit2 <- clm_stan(rating ~ temp, data = wine, link = "probit")
loo::loo_compare(loo(fit1), loo(fit2))
}

}
\seealso{
\code{\link{waic.clmstan}} for WAIC computation,
\code{\link[loo]{loo}} for details on the LOO algorithm,
\code{\link[loo]{loo_compare}} for model comparison.
}
