% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-day.R
\name{year-day-group}
\alias{year-day-group}
\alias{calendar_group.clock_year_day}
\title{Grouping: year-day}
\usage{
\method{calendar_group}{clock_year_day}(x, precision, ..., n = 1L)
}
\arguments{
\item{x}{\verb{[clock_year_day]}

A year-day vector.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
\item \code{"day"}
\item \code{"hour"}
\item \code{"minute"}
\item \code{"second"}
\item \code{"millisecond"}
\item \code{"microsecond"}
\item \code{"nanosecond"}
}}

\item{...}{These dots are for future extensions and must be empty.}

\item{n}{\verb{[positive integer(1)]}

A single positive integer specifying a multiple of \code{precision} to use.}
}
\value{
\code{x} grouped at the specified \code{precision}.
}
\description{
This is a year-day method for the \code{\link[=calendar_group]{calendar_group()}} generic.

Grouping for a year-day object can be done at any precision, as
long as \code{x} is at least as precise as \code{precision}.
}
\examples{
x <- seq(as_naive_time(year_month_day(2019, 1, 1)), by = 5, length.out = 20)
x <- as_year_day(x)
x

# Group by day of the current year
calendar_group(x, "day", n = 20)
}
