% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{convert}
\alias{convert}
\title{Convert Sequence Data to Various Formats}
\usage{
convert(data, cols, format = "frequency")
}
\arguments{
\item{data}{[\code{data.frame}, \code{matrix}, \code{stslist}]\cr
Sequence data in wide format (rows are sequences, columns are time points).}

\item{cols}{[\code{expression}]\cr A tidy selection of columns that should
be considered as sequence data. By default, all columns are used.}

\item{format}{[\code{character(1)}]\cr The format to convert into:
\itemize{
\item \code{"frequency"}: Counts of each state per sequence.
\item \code{"onehot"}: Presence/absence (0/1) of each state per sequence.
\item \code{"edgelist"}: (state, next state) pairs.
\item \code{"reverse"}: Same as \code{"edgelist"} but in the reverse direction, i.e.,
(state, previous state) pairs.
}}
}
\value{
A \code{tibble} structured according to the requested format.
}
\description{
Converts wide format sequence data into useful formats for analysis,
such as frequency table, one-Hot encoding, or edge list (graph format).
}
\examples{
convert(engagement, format = "frequency")
convert(engagement, format = "onehot")
convert(engagement, format = "edgelist")
convert(engagement, format = "reverse")

}
