% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting.R
\name{reportDunnTestTable}
\alias{reportDunnTestTable}
\title{report Dunn test as a table. Customizable with sensible defaults. Required commands in LaTeX:
\code{\\newcommand{\\padjminor}{\\textit{p$_{adj}<$}}}
\code{\\newcommand{\\padj}{\\textit{p$_{adj}$=}}}
\code{\\newcommand{\\rankbiserial}[1]{$r_{rb} = #1$}}}
\usage{
reportDunnTestTable(
  d = NULL,
  data,
  iv = "testiv",
  dv = "testdv",
  orderByP = FALSE,
  numberDigitsForPValue = 4,
  latexSize = "small",
  orderText = TRUE
)
}
\arguments{
\item{d}{the dunn test object}

\item{data}{the data frame}

\item{iv}{independent variable}

\item{dv}{dependent variable}

\item{orderByP}{whether to order by the p value}

\item{numberDigitsForPValue}{the number of digits to show}

\item{latexSize}{which size for the text}

\item{orderText}{whether to order the text}
}
\value{
A message describing the statistical results in a table.
}
\description{
report Dunn test as a table. Customizable with sensible defaults. Required commands in LaTeX:
\code{\\newcommand{\\padjminor}{\\textit{p$_{adj}<$}}}
\code{\\newcommand{\\padj}{\\textit{p$_{adj}$=}}}
\code{\\newcommand{\\rankbiserial}[1]{$r_{rb} = #1$}}
}
\examples{
\donttest{
if (requireNamespace("FSA", quietly = TRUE)) {
  # Use built-in iris data
  data(iris)

  # Dunn test on Sepal.Length by Species
  d <- FSA::dunnTest(Sepal.Length ~ Species,
    data   = iris,
    method = "holm"
  )

  # Report the Dunn test
  reportDunnTestTable(d,
    data = iris,
    iv   = "Species",
    dv   = "Sepal.Length"
  )
}
}
}
