% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{\%eq\%}
\alias{\%eq\%}
\title{Check equality of two objects}
\usage{
x1 \%eq\% x2
}
\arguments{
\item{x1}{The first object to compare}

\item{x2}{The second object to compare}
}
\value{
A single TRUE or FALSE value depending on whether the objects are equal.
}
\description{
The goal of the \code{\%eq\%} operator is to return a TRUE
or FALSE value when any two objects are compared.  The function provides a
simple, reliable equality check that allows comparing
of NULLs, NA values, and atomic data types without error.

The function also allows comparing
of data frames.  It will return TRUE if all values in the
data frames are equal, and ignores differences in attributes.
}
\examples{
# Comparing of NULLs and NA
NULL \%eq\% NULL        # TRUE
NULL \%eq\% NA          # FALSE
NA \%eq\% NA            # TRUE
1 \%eq\% NULL           # FALSE
1 \%eq\% NA             # FALSE

# Comparing of atomic values
1 \%eq\% 1              # TRUE
"one" \%eq\% "one"      # TRUE
1 \%eq\% "one"          # FALSE
1 \%eq\% Sys.Date()     # FALSE

# Comparing of vectors
v1 <- c("A", "B", "C")
v2 <- c("A", "B", "D")
v1 \%eq\% v1            # TRUE
v1 \%eq\% v2            # FALSE

# Comparing of data frames
mtcars \%eq\% mtcars    # TRUE
mtcars \%eq\% iris      # FALSE
iris \%eq\% iris[1:50,] # FALSE

# Mixing it up
mtcars \%eq\% NULL      # FALSE
v1 \%eq\% NA            # FALSE
1 \%eq\% v1             # FALSE
}
\seealso{
Other operators: 
\code{\link{\%ge\%}()},
\code{\link{\%gt\%}()},
\code{\link{\%le\%}()},
\code{\link{\%lt\%}()},
\code{\link{\%ne\%}()},
\code{\link{\%p\%}()}
}
\concept{operators}
