% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace.R
\name{mle_trace}
\alias{mle_trace}
\alias{print.mle_trace}
\title{Create a Trace Configuration}
\usage{
mle_trace(
  values = FALSE,
  path = FALSE,
  gradients = FALSE,
  timing = FALSE,
  every = 1L
)

\method{print}{mle_trace}(x, ...)
}
\arguments{
\item{values}{Track log-likelihood values at each iteration}

\item{path}{Track parameter values at each iteration}

\item{gradients}{Track gradient norms at each iteration}

\item{timing}{Track wall-clock time}

\item{every}{Record every nth iteration (1 = all iterations)}

\item{x}{An mle_trace object.}

\item{...}{Additional arguments (unused).}
}
\value{
An mle_trace configuration object

The input object, invisibly (for method chaining).
}
\description{
Specifies what information to track during optimization.
}
\examples{
# Track everything
trace <- mle_trace(values = TRUE, path = TRUE, gradients = TRUE)

# Minimal tracing (just convergence path)
trace <- mle_trace(values = TRUE)

# Sample every 10th iteration for long runs
trace <- mle_trace(values = TRUE, path = TRUE, every = 10)

}
