% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose.R
\name{race}
\alias{race}
\title{Race Multiple Solvers}
\usage{
race(..., parallel = FALSE)
}
\arguments{
\item{...}{Solver functions to race}

\item{parallel}{Logical; if TRUE and the \pkg{future} package is installed,
solvers are run in parallel using the current future plan. Default is FALSE.}
}
\value{
A new solver function that races all solvers and picks the best
}
\description{
Runs multiple solvers (optionally in parallel) and returns the best result
(highest log-likelihood). More flexible than \code{\%|\%} operator.
}
\details{
When \code{parallel = TRUE}, solvers are executed using \code{future::future()}
and results collected with \code{future::value()}. The current future plan
determines how parallelization happens (e.g., \code{plan(multisession)} for
multi-process execution).

Failed solvers (those that throw errors) are ignored. If all solvers fail,
an error is thrown.
}
\examples{
# Race three methods sequentially
strategy <- race(gradient_ascent(), bfgs(), nelder_mead())

# Race with parallel execution (requires future package)
\dontrun{
future::plan(future::multisession)
strategy <- race(gradient_ascent(), bfgs(), nelder_mead(), parallel = TRUE)
}

}
