% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrations.R
\name{get_integration}
\alias{get_integration}
\title{Get the details of an OAuth integration}
\usage{
get_integration(client, guid)
}
\arguments{
\item{client}{A \code{Connect} R6 client object.}

\item{guid}{The GUID of an integration available on the Connect server.}
}
\value{
A \code{connect_integration} object representing an OAuth integration,
which has the following fields:
\itemize{
\item \code{id}: The internal identifier of this OAuth integration.
\item \code{guid}: The GUID of this OAuth integration.
\item \code{created_time}: The timestamp (RFC3339) indicating when this integration
was created.
\item \code{updated_time}: The timestamp (RFC3339) indicating when this integration
was last updated
\item \code{name}: A descriptive name to identify the OAuth integration.
\item \code{description}: A brief text to describe the OAuth integration.
\item \code{template}: The template used to configure this OAuth integration.
\item \code{auth_type}: The authentication type indicates which OAuth flow is used by
this integration.
\item \code{config}: A list with the OAuth integration configuration. Fields
differ between integrations.
}
}
\description{
Given the GUID of an OAuth integration available on a Connect server, retrieve
its details. You must have administrator or publisher privileges to perform
this action.
}
\examples{
\dontrun{
client <- connect()
x <- get_integration(client, guid)
}

}
\seealso{
\code{\link[=get_integrations]{get_integrations()}}, \code{\link[=get_associations]{get_associations()}}, \code{\link[=set_integrations]{set_integrations()}}

Other oauth integration functions: 
\code{\link{create_integration}()},
\code{\link{delete_integration}()},
\code{\link{get_associations}()},
\code{\link{get_integrations}()},
\code{\link{set_integrations}()},
\code{\link{update_integration}()}
}
\concept{oauth integration functions}
