# convergenceDFM

**convergenceDFM** is an R package for convergence analysis in macro-financial panels, combining Dynamic Factor Models (DFM) with mean-reverting Ornstein-Uhlenbeck (OU) processes.

## Main Features

- **Dynamic Factor Models (DFM):** Static and approximate estimation for large panels with VAR/VECM stability checks, Portmanteau tests, and out-of-sample $R^2$.

- **Cointegration analysis:** Implementation of Johansen's test.

- **Ornstein-Uhlenbeck processes:** Convergence and half-life estimation based on OU processes.

- **Robust inference:** HC/HAC sandwich-type estimators via the 'sandwich' package.

- **Factor preselection:** Methods based on Partial Least Squares (PLS).

- **Visualization:** Publication-ready graphics.

- **Robustness tests:** Complete suite of diagnostics and validation.

## Installation

### From CRAN

```r
install.packages("convergenceDFM")
```

### Development version (GitHub)

```r
# install.packages("devtools")
devtools::install_github("your-username/convergenceDFM")
```

### Optional dependency: cmdstanr

For advanced Bayesian features (optional), install `cmdstanr`:

```r
install.packages("cmdstanr", 
                 repos = c("https://stan-dev.r-universe.dev", 
                          getOption("repos")))
```

**Note:** `cmdstanr` is not on CRAN and must be installed from the Stan repository. The main functionalities of the package **do not require** `cmdstanr`.

## Basic Usage

```r
library(convergenceDFM)

# Basic example (adjust according to your main functions)
# data <- prepare_panel_data(your_data)
# dfm_result <- estimate_dfm(data)
# ou_result <- estimate_ou_process(dfm_result)
# plot_convergence(ou_result)
```

For more examples, see the vignettes:

```r
browseVignettes("convergenceDFM")
```

## Package Structure

```
convergenceDFM/
├── R/                  # Source code
├── data/               # Package datasets
├── inst/               # Additional package files
├── man/                # Documentation (auto-generated by roxygen2)
├── tests/              # Tests with testthat (edition 3)
├── vignettes/          # Vignettes and tutorials
├── DESCRIPTION         # Package metadata
├── LICENSE             # License file
├── NAMESPACE           # Package namespace (auto-generated)
├── NEWS.md             # Changelog
└── README.md           # This file
```

## Development

- **Documentation:** Generated with `roxygen2`.

- **Tests:** Complete suite with `testthat`.

## References

The package implements methods from:

- Forni, M., Hallin, M., Lippi, M., & Reichlin, L. (2000). "The Generalized Dynamic-Factor Model: Identification and Estimation." *Review of Economics and Statistics*, 82(4), 540-554.

- Stock, J. H., & Watson, M. W. (2002). "Forecasting Using Principal Components From a Large Number of Predictors." *Journal of the American Statistical Association*, 97(460), 1167-1179.

- Johansen, S. (1988). "Statistical analysis of cointegration vectors." *Journal of Economic Dynamics and Control*, 12(2-3), 231-254.

- Uhlenbeck, G. E., & Ornstein, L. S. (1930). "On the Theory of the Brownian Motion." *Physical Review*, 36(5), 823.

- Vasicek, O. (1977). "An equilibrium characterization of the term structure." *Journal of Financial Economics*, 5(2), 177-188.

- Zeileis, A. (2004). "Econometric Computing with HC and HAC Covariance Matrix Estimators." *Journal of Statistical Software*, 11(10), 1-17.

- Mevik, B.-H., & Wehrens, R. (2007). "The pls Package: Principal Component and Partial Least Squares Regression in R." *Journal of Statistical Software*, 18(2), 1-23.

## License

This package is free and open source software, licensed under GPL-3.

## Author

**José Mauricio Gómez Julián**  
Email: isadorenabi@pm.me