% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_total_emissions.R
\name{calc_total_emissions}
\alias{calc_total_emissions}
\title{Calculate total emissions (robust and boundary-aware)}
\usage{
calc_total_emissions(...)
}
\arguments{
\item{...}{Results from \code{calc_emissions_*()} functions (lists).}
}
\value{
Object of class \code{cf_total} including:
\itemize{
\item \code{total_co2eq}: total absolute emissions (kg CO2eq yr-1)
\item \code{breakdown}: named numeric vector by source (kg CO2eq yr-1)
\item \code{by_source}: data.frame with \code{source}, \code{co2eq_kg}, and \code{units}
\item \code{units_total}, \code{units_by_source}: unit strings
}
}
\description{
Aggregates results from different sources (enteric, manure, soil, energy, inputs)
even if they don't use exactly the same field name for the total.
IMPORTANT: If a source explicitly reports \code{co2eq_kg = NULL} (e.g. excluded by
system boundaries), it is treated as zero and no fallback summation is attempted.
}
