% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_roche.R
\name{label_roche}
\alias{label_roche}
\alias{style_roche_pvalue}
\alias{label_roche_pvalue}
\alias{style_roche_percent}
\alias{label_roche_percent}
\alias{style_roche_ratio}
\alias{label_roche_ratio}
\alias{style_roche_number}
\alias{label_roche_number}
\title{Formatting percent and p-values}
\usage{
style_roche_pvalue(
  x,
  big.mark = ifelse(decimal.mark == ",", " ", ","),
  decimal.mark = getOption("OutDec"),
  ...
)

label_roche_pvalue(
  big.mark = ifelse(decimal.mark == ",", " ", ","),
  decimal.mark = getOption("OutDec"),
  ...
)

style_roche_percent(
  x,
  digits = 1,
  prefix = "",
  suffix = "",
  scale = 100,
  big.mark = ifelse(decimal.mark == ",", " ", ","),
  decimal.mark = getOption("OutDec"),
  ...
)

label_roche_percent(
  digits = 1,
  suffix = "",
  scale = 100,
  big.mark = ifelse(decimal.mark == ",", " ", ","),
  decimal.mark = getOption("OutDec"),
  ...
)

style_roche_ratio(
  x,
  digits = 2,
  prefix = "",
  suffix = "",
  scale = 1,
  big.mark = ifelse(decimal.mark == ",", " ", ","),
  decimal.mark = getOption("OutDec"),
  ...
)

label_roche_ratio(
  digits = 2,
  prefix = "",
  suffix = "",
  scale = 1,
  big.mark = ifelse(decimal.mark == ",", " ", ","),
  decimal.mark = getOption("OutDec"),
  ...
)

style_roche_number(
  x,
  digits = 0,
  big.mark = ifelse(decimal.mark == ",", " ", ","),
  decimal.mark = getOption("OutDec"),
  scale = 1,
  prefix = "",
  suffix = "",
  na = "NE",
  inf = "NE",
  nan = "NE",
  ...
)

label_roche_number(
  digits = 0,
  big.mark = ifelse(decimal.mark == ",", " ", ","),
  decimal.mark = getOption("OutDec"),
  scale = 1,
  prefix = "",
  suffix = "",
  na = "NE",
  inf = "NE",
  nan = "NE",
  ...
)
}
\arguments{
\item{x}{(\code{numeric})\cr
Numeric vector}

\item{big.mark}{(\code{string})\cr
Character used between every 3 digits to separate
hundreds/thousands/millions/etc.
Default is \code{","}, except when \code{decimal.mark = ","} when the default is a space.}

\item{decimal.mark}{(\code{string})\cr
The character to be used to indicate the numeric decimal point.
Default is \code{"."}  or \code{getOption("OutDec")}}

\item{...}{Arguments passed on to \code{base::format()}}

\item{digits}{(non-negative \code{integer})\cr
Integer or vector of integers specifying the number of decimals
to round \code{x}. When vector is passed, each integer is mapped 1:1 to the
numeric values in \code{x}}

\item{prefix}{(\code{string})\cr
Additional text to display before the number.}

\item{suffix}{(\code{string})\cr
Additional text to display after the number.}

\item{scale}{(scalar \code{numeric})\cr
A scaling factor: \code{x} will be multiplied by scale before formatting.}

\item{na, inf, nan}{(\code{NA}/\code{string})\cr
scalar to replace \code{NA}, infinite, and \code{NaN} values with.
Default is \code{"NE"} for arguments \code{na}, \code{inf}, and \code{nan} argument.}
}
\value{
A character vector of rounded p-values
}
\description{
\itemize{
\item \code{label_roche_pvalue()} returns formatted p-values.
\item \code{label_roche_percent()} returns formatted percent values. This function only formats percentages between 0 and 1.
\item \code{label_roche_ratio()} returns formatted ratios with values below and above a threshold being returned as \verb{< 0.1} and \verb{> 999.9}, for example, when \code{digits=1}.
\item \code{label_roche_number()} returns formatted numbers.
}
}
\examples{
# p-value formatting
x <- c(0.0000001, 0.123456)

style_roche_pvalue(x)
label_roche_pvalue()(x)

# percent formatting
x <- c(0.0008, 0.9998)

style_roche_percent(x)
label_roche_percent()(x)

# ratio formatting
x <- c(0.0008, 0.8234, 2.123, 1000)

style_roche_ratio(x)
label_roche_ratio()(x)

# number formatting
x <- c(0.0008, 0.8234, 2.123, 1000, NA, Inf, -Inf)

style_roche_number(x)
label_roche_number()(x)
}
