% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcf.R
\name{select_terminal_noi}
\alias{select_terminal_noi}
\title{Robust selection of terminal NOI for resale valuation}
\usage{
select_terminal_noi(
  noi,
  vacancy = NULL,
  capex = NULL,
  noi_theoretical = NULL,
  force_theoretical_if_noi_n_zero = TRUE
)
}
\arguments{
\item{noi}{Numeric vector of length \code{N} containing annual NOI values
for years 1..N.}

\item{vacancy}{Optional numeric vector of length \code{N} giving annual
vacancy rates. When \code{NULL}, vacancy is assumed to be zero in all years.}

\item{capex}{Optional numeric vector of length \code{N} giving annual capital
expenditures. When \code{NULL}, capex is assumed to be zero in all years.}

\item{noi_theoretical}{Optional numeric scalar giving a stabilised theoretical
NOI (for example market rent multiplied by area).}

\item{force_theoretical_if_noi_n_zero}{Logical scalar. When \code{TRUE}, and
\code{NOI_N} is numerically zero, \code{noi_theoretical} is used when
available.}
}
\value{
Numeric scalar giving the NOI retained for capitalization.
}
\description{
Chooses a stabilised net operating income (NOI) for terminal value
calculation, using a hierarchical decision rule designed to mitigate
distortions driven by vacancy, capital expenditure, or atypical end-of-horizon
cash-flow patterns.

The selection logic proceeds as follows:
\enumerate{
\item If \code{NOI_N} is (numerically) zero and
\code{force_theoretical_if_noi_n_zero} is \code{TRUE}, use
\code{noi_theoretical} when provided.
\item If year \code{N} is clean (zero vacancy, zero capex, and \code{NOI_N > 0}),
use \code{NOI_N}.
\item If year \code{N} is distorted but year \code{N-1} is clean and
\code{NOI_{N-1} > 0}, use \code{NOI_{N-1}}.
\item Otherwise, if \code{noi_theoretical} is provided, use it.
\item As a last resort, fall back to \code{NOI_N}. A warning is emitted only
when \code{NOI_N <= 0}.
}
}
