% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Backfill-class.R
\docType{class}
\name{RecruitmentRatio-class}
\alias{RecruitmentRatio-class}
\alias{.RecruitmentRatio}
\alias{RecruitmentRatio}
\alias{.DefaultRecruitmentRatio}
\title{\code{RecruitmentRatio}}
\usage{
RecruitmentRatio(ratio = 1)

.DefaultRecruitmentRatio()
}
\arguments{
\item{ratio}{(\code{number})
see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{RecruitmentRatio}} constrains the recruitment of backfill patients
based on a ratio to the main trial cohort size. The maximum number of
backfill patients is calculated as \code{ceiling(ratio * active_cohort_size)}.
}
\section{Slots}{

\describe{
\item{\code{ratio}}{(\code{number})
the recruitment ratio, specifying the maximum number of backfill patients
per patient in the main trial cohort (non-negative).}
}}

\note{
Typically, end users will not use the \code{.DefaultRecruitmentRatio()} function.
}
\examples{
# Create a RecruitmentRatio object with ratio 0.5
# This means 1 backfill patient for every 2 patients in the active cohort
recruitment <- RecruitmentRatio(ratio = 0.5)
print(recruitment)

# Create a variant with ratio 1 (1:1)
recruitment_one_to_one <- RecruitmentRatio(ratio = 1)
print(recruitment_one_to_one)
}
\seealso{
\code{\link{Recruitment}} and the other subclasses listed in there.
}
