% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{validate_method}
\alias{validate_method}
\title{Internal: validate and normalize a single method specification}
\usage{
validate_method(met, mname = NULL)
}
\arguments{
\item{met}{A method specification list.}

\item{mname}{Optional method name (used for error messages).}
}
\value{
A normalized method specification with a fully validated
nuisance graph and an added \code{"__TARGET__"} node.
}
\description{
Validates a method specification and normalizes its nuisance graph.
This includes:
\itemize{
\item checking \code{mode}, \code{eval_fold}, \code{folds},
and \code{repeats},
\item validating the nuisance container,
\item checking that the target is a function and that its required
arguments are nuisances,
\item attaching a synthetic \code{"__TARGET__"} nuisance node,
\item inferring \code{fit_deps} and \code{pred_deps} from required
arguments,
\item enforcing coverage of required arguments,
\item and running a cycle check on the full graph.
}
}
\details{
This function is normally called from \code{validate_batch()} and is
not intended to be used directly by end users.
}
\keyword{internal}
