% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrdata-package.R
\docType{package}
\name{ctrdata}
\alias{ctrdata}
\title{Getting started, database connection, function overview}
\description{
\code{ctrdata} is a package for aggregating and analysing data on clinical
studies, and for obtaining documents, from public trial registers
}
\section{1 - Define a database connection}{

Package \code{ctrdata} retrieves trial data and stores it in a database
collection. The connection is specified using \code{nodbi}, which allows to
use different database backends in an identical way.
A database connection object is specified once and then can be used as
parameter \code{con} in subsequent calls of \code{ctrdata} functions.
Specifying \code{collection = "<my trial data collection's name>"}
indicates the table in the database that package \code{ctrdata} should use.\tabular{ll}{
   \emph{Database} \tab \emph{Connection object} \cr
   SQLite \tab \code{dbc <- \link[nodbi:src_sqlite]{nodbi::src_sqlite}(dbname = "my_db", collection = "my_coll")} \cr
   DuckDB \tab \code{dbc <- \link[nodbi:src_duckdb]{nodbi::src_duckdb}(dbname = "my_db", collection = "my_coll")} \cr
   MongoDB \tab \code{dbc <- \link[nodbi:src_mongo]{nodbi::src_mongo}(db = "my_db", collection = "my_coll")} \cr
   PostgreSQL \tab \code{dbc <- \link[nodbi:src_postgres]{nodbi::src_postgres}(dbname = "my_db"); dbc[["collection"]] <- "my_coll"} \cr
}
}

\section{2 - Load information from clinical trial registers}{


\link{ctrGenerateQueries} (generate from simple user input specific queries
for registers EUCTR, CTIS, CTGOV2 and ISRCTN),
\link{ctrOpenSearchPagesInBrowser} (open queries in browser),
see \href{https://raw.githubusercontent.com/rfhb/ctrdata/master/tools/ctrdataURLcopier.js}{script}
(automatically copy user search in any register to clipboard),
see \link{ctrdata-registers} for details on registers and how to search,
\link{ctrLoadQueryIntoDb} (load trial records found with query into database collection).
}

\section{3 - Use database with downloaded trial information}{


\link{ctrShowOneTrial} (show widget to explore structure, fields and data of a trial),
\link{dbFindFields} (find names of fields of interest in trial records in a collection),
\link{dbGetFieldsIntoDf} (create a data frame with fields of interest and calculated trial concepts from collection),
\link{ctrdata-trial-concepts} (calculate pre-defined trial concepts across registers),
\link{dbFindIdsUniqueTrials} (get de-duplicated identifiers of clinical trials' records to subset a data frame).
}

\section{4 - Operate on a trial data frame from dbGetFieldsIntoDf}{


\link{dfTrials2Long} (convert fields with nested elements into long format),
\link{dfName2Value} (get values for variable(s) of interest),
\link{ctrdata-trial-concepts} (calculate pre-defined trial concepts for every register).
}

\seealso{
Useful links:
\itemize{
  \item \url{https://cran.r-project.org/package=ctrdata}
  \item \url{https://rfhb.github.io/ctrdata/}
  \item Report bugs at \url{https://github.com/rfhb/ctrdata/issues}
}

}
\author{
Ralf Herold \email{ralf.herold@mailbox.org}
}
\keyword{package}
