% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.dataquieR_resultset2.R
\name{print.dataquieR_resultset2}
\alias{print.dataquieR_resultset2}
\title{Generate a HTML-based report from a \link{dataquieR} report}
\usage{
\method{print}{dataquieR_resultset2}(
  x,
  dir,
  view = TRUE,
  disable_plotly = FALSE,
  block_load_factor = getOption("dataquieR.print_block_load_factor",
    dataquieR.print_block_load_factor_default),
  advanced_options = list(),
  dashboard = NA,
  ...,
  cores = list(mode = "socket", logging = FALSE, cpus = util_detect_cores(),
    load.balancing = TRUE)
)
}
\arguments{
\item{x}{\link[=dq_report2]{dataquieR report v2}.}

\item{dir}{\link{character} directory to store the rendered report's files,
a temporary one,
if omitted. Directory will be created, if missing, files may be
overwritten inside that directory}

\item{view}{\link{logical} display the report}

\item{disable_plotly}{\link{logical} do not use \code{plotly}, even if installed}

\item{block_load_factor}{\link{numeric} see \link{dataquieR.print_block_load_factor}}

\item{advanced_options}{\link{list} options to set during report computation,
see \code{\link[=options]{options()}}}

\item{dashboard}{\link{logical} dashboard mode: \code{TRUE}: create a dashboard only,
\code{FALSE}: don't create a dashboard at all,
\code{NA} or missing: create a "normal" report with
a dashboard included.}

\item{...}{additional arguments:}

\item{cores}{\link{integer} number of cpu cores to use or a named list with
arguments for \link[parallelMap:parallelStart]{parallelMap::parallelStart} or NULL,
if parallel has already been started by the caller.
Can also be a cluster.}
}
\value{
file names of the generated report's HTML files
}
\description{
Generate a HTML-based report from a \link{dataquieR} report
}
