% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionDatasets.R
\name{DeletePredictionDataset}
\alias{DeletePredictionDataset}
\title{Delete a specified prediction dataset}
\usage{
DeletePredictionDataset(project, datasetId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{datasetId}{The id of the dataset to delete}
}
\description{
This function removes a prediction dataset
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  datasets <- ListPredictionDatasets(projectId)
  dataset <- datasets[[1]]
  datasetId <- dataset$id
  DeletePredictionDataset(projectId, datasetId)
}
}
