% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animations.R
\name{animate_topo}
\alias{animate_topo}
\title{Topographic map animation in time}
\usage{
animate_topo(
  data,
  amplitude,
  t_lim,
  FS = 250,
  t0 = 1,
  mesh,
  coords = NULL,
  template = NULL,
  col_range = NULL,
  col_scale = NULL,
  show_legend = TRUE,
  contour = FALSE,
  output_path = NULL,
  ...
)
}
\arguments{
\item{data}{An input data frame or tibble with at least this required columns: \code{time} - the number of time point, \code{sensor} - the sensor label and the column with the EEG amplitude to plot specified in the argument \code{amplitude}.}

\item{amplitude}{A character specifying the name of the column from input data with EEG amplitude values.}

\item{t_lim}{A numeric vector of length 2 with limits of time points (i.e., the length of the timeline displayed below the animation).}

\item{FS}{The sampling frequency. Default value is 250 Hz.}

\item{t0}{Index of the zero time point, i.e. point, where 0 ms should be marked (most often time of the stimulus or time of the response).}

\item{mesh}{A \code{"mesh"} object (or a named list with the same structure) containing at least \code{D2} element with x and y coordinates of a point mesh used for computing IM model. If not defined, the point mesh with default settings from \code{\link{point_mesh}} function is used.}

\item{coords}{Sensor coordinates as a tibble or data frame with named \code{x}, \code{y} columns of sensor coordinates and \code{sensor} column with sensor names. If not defined, the HCGSN256 template is used.}

\item{template}{The kind of sensor template montage used. Currently the only available option is \code{"HCGSN256"} denoting the 256-channel HydroCel Geodesic Sensor Net v.1.0, which is also a default setting.}

\item{col_range}{A vector with minimum and maximum value of the amplitude used in the colour palette for plotting. If not defined, the range of interpolated signal is used.}

\item{col_scale}{Optionally, a colour scale to be utilised for plotting. If not defined, it is computed from \code{col_range}.}

\item{show_legend}{Logical. Indicates, whether legend should be displayed beside the graph. Default value is \code{TRUE}.}

\item{contour}{Logical. Indicates, whether contours should be plotted in the graph. Default value is \code{FALSE}.}

\item{output_path}{File path where the animation will be saved using \code{gifski} renderer (optional). If not defined, the animation is plotted in the RStudio Viewer.}

\item{...}{Additional parameters for animation according to \link[gganimate:animate]{gganimate::animate}.}
}
\value{
If \code{output_path} is \code{NULL}, the function prints the animation to the RStudio Viewer.
If \code{output_path} is specified, the animation is saved to the given file path and not displayed.
}
\description{
Display a topographic animation of the change in amplitude over time. The function enables direct rendering in Rstudio Viewer or saving the animation in gif format to the chosen location.
}
\details{
For more details about required mesh structure see \code{\link{point_mesh}} function. If the input \code{mesh} structure does not match this format, an error or incorrect function behavior may occur.

The time part of input data is assumed to be in numbers of time points, conversion to ms takes place inside the function for drawing the timeline labels.
Due to the flexibility of the function (e.g. to mark and animate only a short section from the entire time course or to compare different data in the same time interval), it allows to enter and plot user-defined time ranges. If some values of the time are outside the \code{t_lim} range, the function writes a warning message - in that case the animation is still rendered, but the timeline will not match reality.

Note: When specifying the \code{coords} and \code{template} at the same time, the \code{template} parameter takes precedence and the \code{coords} parameter is ignored.
}
\examples{
\donttest{
# This example may take a few seconds to render.
# Run only if you want to generate the full animation.
# Prepare a data structure:
s1e05 <- epochdata |> dplyr::filter(subject == 1 & epoch == 5 & time \%in\% c(10:20))
# Plot animation
# t0 = 10 indicates the time point of stimulus in epochdata,
# t_lim is the whole range of epochdata, we animate only a short period
animate_topo(s1e05, amplitude = "signal", t_lim = c(1,50), t0 = 10)
}

}
\seealso{
\code{\link{topo_plot}}
}
