% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeplots.R
\name{interactive_waveforms}
\alias{interactive_waveforms}
\title{Plot interactive waveform graph}
\usage{
interactive_waveforms(
  data,
  amplitude = "signal",
  FS = 250,
  t0 = NULL,
  col_palette,
  level = "epoch",
  avg = TRUE,
  CI = FALSE,
  use_latex = TRUE
)
}
\arguments{
\item{data}{A data frame, tibble or a database table with input data containing a \code{time} column and columns corresponding to the selected \code{amplitude} and \code{level} parameter (see Details).}

\item{amplitude}{A character specifying the name of the column from input data with an EEG amplitude values. Default is \code{"signal"}.}

\item{FS}{The sampling frequency. Default value is 250 Hz.}

\item{t0}{Index of the zero time point, i.e. point, where 0 ms should be marked (most often time of the stimulus or time of the response).}

\item{col_palette}{Optionally, a colour palette for plotting lines. If missing, the rainbow palette is used. The expected length is the same (or higher) as the number of unique levels (e.g. number of epochs for \code{level = "epoch"}).}

\item{level}{A character specifying the level of the time curves. The possible values are \code{"epoch"} (default option), \code{"condition"}, \code{"sensor"}, \code{"subject"} and \code{"group"}. See details for more information.}

\item{avg}{A logical value indicating, if the average black curve should be plotted. Default is \code{TRUE}.}

\item{CI}{A logical value indicating, if the confidence ribbon should be plotted. Default is \code{FALSE}. See Details for more information.}

\item{use_latex}{A logical value indicating whether to use LaTeX formatting for the y-axis title. The default is \code{TRUE}.}
}
\value{
A \code{plotly} object showing an interactive time series of the signal according to the chosen level.
}
\description{
Function for plotting time series of EEG signal colour-coded by epoch, condition, channel, subject or group (depending on selected \code{level} parameter) an interactive \code{plotly} graph. The function assumes that the input data have already been filtered to the desired subset according to the \code{level}.
When using the function for plotting the average, there is an option to add a confidence band using the \code{CI} argument.
The output in \link[plotly]{plotly} format enables to easily edit the image layout.
}
\details{
The input data frame or database table must contain column \code{time} (a column with time point numbers) and a column with the EEG amplitude (or average amplitude) specified in the argument \code{amplitude}.\if{html}{\out{<br>}}
It must also contain at least one of the optional columns (according to the \code{level} parameter - for \code{"sensor"} level the column \code{sensor} is required etc.):\if{html}{\out{<br>}}
\code{group} - a column with group identifiers,\if{html}{\out{<br>}}
\code{subject} - a column with subject IDs,\if{html}{\out{<br>}}
\code{sensor} - a column with sensor labels,\if{html}{\out{<br>}}
\code{epoch} - a column with epoch numbers.

Note: The average signals must be pre-aggregated before plotting at higher grouping levels, for example \code{sensor} level assumes a mean sensor signal in the \code{amplitude} column (the input data for individual epochs together with sensor level setting will result in a mess output).

Plotting confidence ribbon:
To plot the confidence bands around the average lines (\code{CI = TRUE}), the input data must include the \code{ci_up} and \code{ci_low} columns (as in the output tibble from \code{\link{compute_mean}} function).
}
\examples{
# 1) Plot epoch waveforms with average curve for subject 1 and electrode "E65"
# with 250 sampling frequency rate (default) and 10 as zero time point
epochdata |>
pick_data(subject_rg = 1, sensor_rg = "E65") |>
interactive_waveforms(amplitude = "signal", t0 = 10, level = "epoch")

# 2) Plot sensor level waveforms with confidence bands for subject 1 and electrodes "E65" and "E182"
# a) preparing data
sendata <- epochdata |>
pick_data(subject_rg = 1, sensor_rg = c("E65", "E182")) |>
compute_mean(amplitude = "signal", domain = "time", level = "epoch")
# b) plot the waveforms without the average
interactive_waveforms(sendata, amplitude = "average", t0 = 10,
level = "sensor", avg = FALSE, CI = TRUE)
}
