% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_conditions.R
\name{discord_cond}
\alias{discord_cond}
\title{Custom Conditions for the discord package}
\usage{
discord_cond(type, msg, class = paste0("discord-", type), call = NULL, ...)
}
\arguments{
\item{type}{One of the following conditions: c("error", "warning", "message")}

\item{msg}{Message}

\item{class}{Default is to prefix the 'type' argument with "discord", but can be more specific to the problem at hand.}

\item{call}{What triggered the condition?}

\item{...}{Additional arguments that can be coerced to character or single condition object.}
}
\value{
A condition for discord.
}
\description{
Custom Conditions for the discord package
}
\examples{
\dontrun{

derr <- function(x) discord_cond("error", x)
dwarn <- function(x) discord_cond("warning", x)
dmess <- function(x) discord_cond("message", x)

return_class <- function(func) {
  tryCatch(func,
    error = function(cond) class(cond),
    warning = function(cond) class(cond),
    message = function(cond) class(cond)
  )
}

return_class(derr("error-class"))
return_class(dwarn("warning-class"))
return_class(dmess("message-class"))
}

}
