% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legacy.R
\name{discord_data_legacy}
\alias{discord_data_legacy}
\title{Legacy Code: Restructure Data}
\usage{
discord_data_legacy(
  outcome,
  predictors = NULL,
  doubleentered = TRUE,
  sep = "",
  scale = FALSE,
  df = NULL,
  id = NULL,
  full = TRUE,
  ...
)
}
\arguments{
\item{outcome}{Name of outcome variable}

\item{predictors}{Names of predictors.}

\item{doubleentered}{Describes whether data are double entered. Default is FALSE.}

\item{sep}{The character in \code{df} that separates root outcome and predictors from mean and diff labels character string to separate the names of the \code{predictors} and \code{outcome}s from kin identifier (1 or 2). Not \code{NA_character_}.}

\item{scale}{If TRUE, rescale all variables at the individual level to have a mean of 0 and a SD of 1.}

\item{df}{dataframe with all variables in it.}

\item{id}{id variable (optional).}

\item{full}{If TRUE, returns kin1 and kin2 scores in addition to diff and mean scores. If FALSE, only returns diff and mean scores.}

\item{...}{Optional pass on additional inputs.}
}
\value{
Returns \code{data.frame} with the following variables:
\item{id}{id}
\item{outcome_1}{outcome for kin1; kin1 is always greater than kin2, except when tied. Then kin1 is randomly selected from the pair}
\item{outcome_2}{outcome for kin2}
\item{outcome_diff}{difference between outcome of kin1 and kin2}
\item{outcome_mean}{mean outcome for kin1 and kin2}
\item{predictor_i_1}{predictor variable i for kin1}
\item{predictor_i_2}{predictor variable i for kin2}
\item{predictor_i_diff}{difference between predictor i of kin1 and kin2}
\item{predictor_i_mean}{mean predictor i for kin1 and kin2}
}
\description{
This is from
\url{https://github.com/R-Computing-Lab/discord/blob/74323b2cdd739355cd4a388251c747f1bcd87eb5/R/discord_data.R}
and is legacy code used to restructure wide form, double-entered data, into
analyzable data sorted by outcome. This can be used in \code{\link{discord_regression_legacy}}.
}
\keyword{internal}
