% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_left_right.R
\name{prob_left}
\alias{prob_left}
\alias{prob_right}
\title{Find the probability left or right of a number}
\usage{
prob_left(distribution, of, inclusive)

prob_right(distribution, of, inclusive)
}
\arguments{
\item{distribution}{Distribution to find probabilities of.}

\item{of}{Find the probability to the left or right \emph{of} this number.
Could be a vector.}

\item{inclusive}{Should \code{of} be included in the probability calculation?
Logical.}
}
\value{
A vector of probabilities.
}
\description{
Probability to the left or right of a number, inclusive or not.
\code{prob_left()} is a more general cdf defined using either \code{<} or \code{<=}, and
\code{prob_right()} is a more general survival function defined using either
\code{>} or \code{>=}.
}
\examples{
d <- dst_pois(5)
prob_left(d, of = 3, inclusive = TRUE)
prob_left(d, of = 3, inclusive = FALSE)
prob_right(d, of = 0:3, inclusive = TRUE)
}
