% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{correlationTest}
\alias{correlationTest}
\title{Run date randomization test for temporal signal on a set of trees.}
\usage{
correlationTest(
  clones,
  permutations = 1000,
  minlength = 0.001,
  perm_type = c("clustered", "uniform"),
  time = "time",
  sequence = "sequence_id",
  germline = "Germline",
  verbose = FALSE,
  polyresolve = TRUE,
  alternative = c("greater", "two.sided"),
  storeTree = FALSE,
  nproc = 1
)
}
\arguments{
\item{clones}{A \code{tibble} object containing airrClone and \code{phylo} objects}

\item{permutations}{Number of permutations to run}

\item{minlength}{Branch lengths to collapse in trees}

\item{perm_type}{Permute among single timepoint clades or uniformly
among tips}

\item{time}{Column name holding numeric time information}

\item{sequence}{Column name holding sequence ID}

\item{germline}{Germline sequence name}

\item{verbose}{Print lots of rubbish while running?}

\item{polyresolve}{Resolve polytomies to have a minimum number of 
single timepoint clades}

\item{alternative}{Is alternative that the randomized correlation are greater than 
or equal to observed, or greater/less than?}

\item{storeTree}{Store the tree used?}

\item{nproc}{Number of cores to use for calculations. Parallelizes by tree.}
}
\value{
A \code{tibble} with the same columns as clones, but additional
columns corresponding to test statistics for each clone.
}
\description{
\code{correlationTest} performs root-to-tip regression date randomization test
}
\details{
Object returned contains these columns which are added or modified from input:
 \itemize{
  \item  \code{data}: airrClone object, same as input but with additional columns 
       "cluster" which correspond to permutation cluster, and "divergence."
  \item  \code{slope}: Slope of linear regression between divergence and time.
  \item  \code{correlation}: Correlation between divergence and time.
  \item  \code{p}: p value of correlation compared to permuted correlations.
  \item  \code{random_correlation}: Mean correlation of permutation replicates.
  \item  \code{min_p}: Minimum p value of data, determined by either the number of
        distinct clade/timepoint combinations or number of permutations.
  \item  \code{nposs}: Number of possible distinct timepoint/clade combinations.
  \item  \code{nclust}: Number of clusters used in permutation. If perm_type="uniform"
        this is the number of tips.
  \item  \code{p_gt/p_lt}: P value that permuted correlations are greater or less 
        than observed correlation. Only returned if alternative = "two.sided"
  \item  \code{test_trees}:  The \code{phylo} tree objects used, possibly with
         resolved polytomies.
}
}
\seealso{
Uses output from \code{getTrees}.
}
