% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{event_count_by}
\alias{event_count_by}
\title{Summarise adverse events by arm and other grouping variables}
\usage{
event_count_by(
  dt,
  patient,
  treat,
  rows_by,
  target,
  .total_dt = dt,
  indent = nbsp(n = 4L),
  pct_dec = 1
)
}
\arguments{
\item{dt}{A \code{data.frame} or \code{data.table} containing the adverse event data
and patient-level identifiers.}

\item{patient}{A string giving the name of the patient identifier variable
(e.g., \code{"USUBJID"}).}

\item{treat}{A string giving the name of the treatment arm variable (e.g.,
\code{"ARM"}).}

\item{rows_by}{A string giving the name of the grouping variable (e.g.,
\code{"AEBODSYS"} for body system).}

\item{target}{A string giving the name of the variable to report within each
group (e.g., \code{"AEDECOD"} for preferred term).}

\item{.total_dt}{A \code{data.frame} or \code{data.table} containing the denominator
population. Defaults to \code{dt}.}

\item{indent}{A string used to indent row labels (e.g., \code{"  "} or \code{nbsp(n = 4L)}).}

\item{pct_dec}{Integer. Number of decimal places to show in percentages.
Defaults to \code{1}.}
}
\value{
A \code{data.table} with the following structure:
\itemize{
\item One row per combination of \code{rows_by} and \code{target}
\item One row per group total (\verb{Total number of events})
\item One row per patient-level total (\verb{Total number of patients with at least one event})
}

Columns include:
\itemize{
\item \code{stats}: character column with labels
\item one column per level of the \code{treat} variable, formatted as \code{"n (x\%)"}
}
}
\description{
\code{event_count_by()} creates a tabular summary of adverse events grouped by a
higher-level classification variable (e.g., system organ class), and counts
both the number of events and the number of unique patients per treatment arm.
}
\examples{
event_count_by(
  dt = adae[adae$ANL01FL == "Y"],
  patient = 'USUBJID',
  treat = 'ARM',
  rows_by = 'AEBODSYS',
  target = 'AEDECOD',
  .total_dt = adsl,
  indent = ' '
)

}
\seealso{
\code{\link[=event_count]{event_count()}}, \code{\link[=calc_stats]{calc_stats()}}, \code{\link[=total_events]{total_events()}}
}
