% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddbs_utils.R
\name{ddbs_drivers}
\alias{ddbs_drivers}
\title{Get list of GDAL drivers and file formats}
\usage{
ddbs_drivers(conn)
}
\arguments{
\item{conn}{A connection object to a DuckDB database}
}
\value{
\code{data.frame}
}
\description{
Get list of GDAL drivers and file formats
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
## load packages
library(duckdb)
library(duckspatial)

## database setup
conn <- dbConnect(duckdb())
ddbs_install(conn)
ddbs_load(conn)

## check drivers
ddbs_drivers(conn)
\dontshow{\}) # examplesIf}
}
