% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dct_drop_row.R
\name{dct_drop_row}
\alias{dct_drop_row}
\title{Drop row(s) of a taxonomic database}
\usage{
dct_drop_row(tax_dat, taxonID = NULL, scientificName = NULL)
}
\arguments{
\item{tax_dat}{Dataframe; taxonomic database in DwC format.}

\item{taxonID}{Character or numeric vector; taxonID of the row(s)
to be dropped.}

\item{scientificName}{Character vector; scientificName of the row(s)
to be dropped.}
}
\value{
Dataframe; taxonomic database in DwC format
}
\description{
Drop one or more rows from a taxonomic database in Darwin Core (DwC) format
by taxonID or scientificName.
}
\details{
Only works if values of taxonID or scientificName are unique and non-missing
in the taxonomic database (tax_dat).

Either taxonID or scientificName should be provided, but not both.
}
\examples{
# Can drop rows by scientificName or taxonID
dct_filmies |>
  dct_drop_row(scientificName = "Cephalomanes atrovirens Presl")

dct_filmies |>
  dct_drop_row(taxonID = "54133783")

# Can drop multiple rows at once by providing multiple values for
# scientificName or taxonID
dct_filmies |>
  dct_drop_row(
    scientificName = c(
      "Cephalomanes atrovirens Presl",
      "Trichomanes crassum Copel."
    )
  )

dct_filmies |>
  dct_drop_row(
    taxonID = c(
      "54133783", "54133783"
    )
  )
}
