#' Ratings on items from the Positive-Negative Relationship Quality Scale (PNRQ; Rogge et al., 2017) from 219 (M)ixed-sex couples
#'
#'A data set containing ratings on items (4 each) assessing romantic (1) satisfaction and (2) dissatisfaction
#'for each member of a mixed-sex dyad .
#'Positive-Negative Relationship Quality Scale (Rogge et al., 2017).
#'Data are from Prine et al. (Under Review).
#'Variable names follow a stem-item-partner ("sip") order, with a delimiter ("_") between
#'the item number and distinguishing partner character.
#'
#' @docType data
#'
#' @usage data(pnrqM)
#'
#' @format A data frame with 219 rows and 16 variables. Participants responded--on a six-point scale (1 = "Not at all true", 6 = "Completely true")--to the prompt, "My relationship is...":
#' \describe{
#'  \item{sat.pnrq1_w}{Enjoyable for partner w}
#'  \item{sat.pnrq2_w}{Pleasant for partner w}
#'  \item{sat.pnrq3_w}{Strong for partner w}
#'  \item{sat.pnrq4_w}{Alive for partner w}
#'  \item{dsat.pnrq1_w}{Miserable for partner w}
#'  \item{dsat.pnrq2_w}{Bad for partner w}
#'  \item{dsat.pnrq3_w}{Empty for partner w}
#'  \item{dsat.pnrq4_w}{Lifeless for partner w}
#'  \item{sat.pnrq1_m}{Enjoyable for partner m}
#'  \item{sat.pnrq2_m}{Pleasant for partner m}
#'  \item{sat.pnrq3_m}{Strong for partner m}
#'  \item{sat.pnrq4_m}{Alive for partner m}
#'  \item{dsat.pnrq1_m}{Miserable for partner m}
#'  \item{dsat.pnrq2_m}{Bad for partner m}
#'  \item{dsat.pnrq3_m}{Empty for partner m}
#'  \item{dsat.pnrq4_m}{Lifeless for partner m}
#'
#' }
#'
#'@references Prine, M., Sakaluk, J. K., Camanto, O. J., & Quinn-Nilas, C. (Under Review).
#'
"pnrqM"
