% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebnm_methods.R
\name{simulate.ebnm}
\alias{simulate.ebnm}
\title{Sample from the posterior of a fitted EBNM model}
\usage{
\method{simulate}{ebnm}(object, nsim = 1, seed = NULL, ...)
}
\arguments{
\item{object}{The fitted \code{ebnm} object.}

\item{nsim}{The number of posterior samples to return per observation.}

\item{seed}{Either \code{NULL} or an integer that will be used in a call to
\code{set.seed} before simulating. If set, the value is saved as the
\code{"seed"} attribute of the returned value. The default, \code{NULL},
will not change the random generator state.}

\item{...}{Additional arguments to be passed to the posterior sampler
function. Since \code{ebnm_horseshoe} returns an MCMC sampler, it takes
parameter \code{burn}, the number of burn-in samples to discard.  At
present, no other samplers take any additional parameters.}
}
\value{
A matrix of posterior samples, with rows corresponding to
  distinct samples and columns corresponding to observations.
}
\description{
The \code{\link[stats]{simulate}} method for class \code{\link{ebnm}}.
  Extracts the posterior sampler from an object of class \code{\link{ebnm}}
  and returns a specified number of samples.
}
