% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{e_jitter}
\alias{e_jitter}
\title{Axis Jitter}
\usage{
e_jitter(e, axis = "x", jitter = 20, jitterOverlap = FALSE, jitterMargin = 5)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{axis}{Axis to apply formatter to. Supports x and y axis}

\item{jitter}{Pixel units indicating the amount of random noise to add to each data point position.}

\item{jitterOverlap}{Boolean allowing overlap between data points. If false, overlap will not be allowed. For some cases, scatters may still overlap if there is no reasonable way to avoid.}

\item{jitterMargin}{When you have jitter and jiterOverlap is FALSE, this is the minimum distance in pixels between two data points.}
}
\description{
helper function for generating jitter between points in a scatter plot. This is only applicable to e_scatter().
}
\examples{

df <- data.frame(
value = c(rnorm(50, mean = 5, sd = 1),
         rnorm(50, mean = 10, sd = 1),
         rnorm(50, mean = 15, sd = 1)),
         group = rep(c("Group A", "Group B", "Group C"), each = 50)
          )

df |> e_charts(group) |> e_scatter(value) |> e_jitter()
}
\seealso{
\href{https://echarts.apache.org/en/option.html#yAxis.jitter}{Additional arguments}
}
